/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class SystemOperationSpecBase {
    private final List<YPath> inputTables;
    private final YPath outputTable;
    @Nullable
    private final String pool;
    @Nullable
    private final String title;
    private final Map<String, YTreeNode> outputTableAttributes;
    private final Map<String, YTreeNode> additionalSpecParameters;

    protected SystemOperationSpecBase(Builder<?> builder) {
        this.inputTables = new ArrayList<YPath>(builder.inputTables);
        if (builder.outputTable == null) {
            throw new RuntimeException("output table is not set");
        }
        this.outputTable = builder.outputTable;
        this.pool = builder.pool;
        this.title = builder.title;
        this.outputTableAttributes = builder.outputTableAttributes;
        this.additionalSpecParameters = builder.additionalSpecParameters;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemOperationSpecBase spec = (SystemOperationSpecBase)obj;
        return this.inputTables.equals(spec.inputTables) && this.outputTable.equals(spec.outputTable) && Optional.ofNullable(this.pool).equals(Optional.ofNullable(spec.pool)) && Optional.ofNullable(this.title).equals(Optional.ofNullable(spec.title)) && this.outputTableAttributes.equals(spec.outputTableAttributes) && this.additionalSpecParameters.equals(spec.additionalSpecParameters);
    }

    public List<YPath> getInputTables() {
        return this.inputTables;
    }

    public YPath getOutputTable() {
        return this.outputTable;
    }

    public Optional<String> getPool() {
        return Optional.ofNullable(this.pool);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Map<String, YTreeNode> getOutputTableAttributes() {
        return this.outputTableAttributes;
    }

    public Map<String, YTreeNode> getAdditionalSpecParameters() {
        return this.additionalSpecParameters;
    }

    public YTreeBuilder toTree(YTreeBuilder mapBuilder, SpecPreparationContext context) {
        return mapBuilder.key("started_by").apply(b -> SpecUtils.startedBy(b, context)).key("input_table_paths").value(this.inputTables, (b, t) -> t.toTree(b)).key("output_table_path").apply(arg_0 -> ((YPath)this.outputTable).toTree(arg_0)).when(this.pool != null, b -> b.key("pool").value(this.pool)).when(this.title != null, b -> b.key("title").value(this.title)).apply(b -> {
            for (Map.Entry<String, YTreeNode> node : this.additionalSpecParameters.entrySet()) {
                b.key(node.getKey()).value(node.getValue());
            }
            return b;
        });
    }

    @NonNullApi
    @NonNullFields
    public static abstract class Builder<T extends Builder<T>> {
        private List<YPath> inputTables = new ArrayList<YPath>();
        @Nullable
        private YPath outputTable;
        @Nullable
        private String pool;
        @Nullable
        private String title;
        private Map<String, YTreeNode> outputTableAttributes = new HashMap<String, YTreeNode>();
        private Map<String, YTreeNode> additionalSpecParameters = new HashMap<String, YTreeNode>();

        public T setInputTables(Collection<YPath> inputTables) {
            this.inputTables = new ArrayList<YPath>(inputTables);
            return this.self();
        }

        public T setInputTables(YPath ... inputTables) {
            return this.setInputTables(Arrays.asList(inputTables));
        }

        public T addInputTable(YPath inputTable) {
            this.inputTables.add(inputTable);
            return this.self();
        }

        public T setOutputTable(YPath outputTable) {
            this.outputTable = outputTable;
            return this.self();
        }

        public T setOutputTableAttributes(Map<String, YTreeNode> outputTableAttributes) {
            this.outputTableAttributes = new HashMap<String, YTreeNode>(outputTableAttributes);
            return this.self();
        }

        public T plusOutputTableAttribute(String key, @Nullable Object value) {
            return this.plusOutputTableAttribute(key, YTree.node((Object)value));
        }

        public T plusOutputTableAttribute(String key, YTreeNode value) {
            this.outputTableAttributes.put(key, value);
            return this.self();
        }

        public T setPool(@Nullable String pool) {
            this.pool = pool;
            return this.self();
        }

        public T setTitle(@Nullable String title) {
            this.title = title;
            return this.self();
        }

        public T setAdditionalSpecParameters(Map<String, YTreeNode> additionalSpecParameters) {
            this.additionalSpecParameters = new HashMap<String, YTreeNode>(additionalSpecParameters);
            return this.self();
        }

        public T plusAdditionalSpecParameter(String key, @Nullable Object value) {
            return this.plusAdditionalSpecParameter(key, YTree.node((Object)value));
        }

        public T plusAdditionalSpecParameter(String key, YTreeNode value) {
            this.additionalSpecParameters.put(key, value);
            return this.self();
        }

        protected abstract T self();
    }
}

