/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class UserOperationSpecBase {
    private final List<YPath> inputTables;
    private final List<YPath> outputTables;
    @Nullable
    private final String pool;
    @Nullable
    private final String title;
    private final Map<String, String> secureVault;
    private final Map<String, YTreeNode> additionalSpecParameters;
    private final Map<String, YTreeNode> outputTableAttributes;

    protected UserOperationSpecBase(Builder<?> builder) {
        if (builder.inputTables.isEmpty()) {
            throw new RuntimeException("input tables are not set");
        }
        if (builder.outputTables.isEmpty()) {
            throw new RuntimeException("output tables are not set");
        }
        this.inputTables = builder.inputTables;
        this.outputTables = builder.outputTables;
        this.pool = builder.pool;
        this.title = builder.title;
        this.secureVault = new HashMap<String, String>(builder.secureVault);
        this.additionalSpecParameters = new HashMap<String, YTreeNode>(builder.additionalSpecParameters);
        this.outputTableAttributes = new HashMap<String, YTreeNode>(builder.outputTableAttributes);
    }

    public List<YPath> getInputTables() {
        return this.inputTables;
    }

    public List<YPath> getOutputTables() {
        return this.outputTables;
    }

    public Optional<String> getPool() {
        return Optional.ofNullable(this.pool);
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public Map<String, String> getSecureVault() {
        return this.secureVault;
    }

    public Map<String, YTreeNode> getOutputTableAttributes() {
        return this.outputTableAttributes;
    }

    public Map<String, YTreeNode> getAdditionalSpecParameters() {
        return this.additionalSpecParameters;
    }

    protected YTreeBuilder toTree(YTreeBuilder mapBuilder, SpecPreparationContext context) {
        mapBuilder.key("started_by").apply(b -> SpecUtils.startedBy(b, context)).key("input_table_paths").value(this.inputTables, (b, t) -> t.toTree(b)).key("output_table_paths").value(this.outputTables, (b, t) -> t.toTree(b)).when(this.pool != null, b -> b.key("pool").value(this.pool)).when(this.title != null, b -> b.key("title").value(this.title)).when(!this.secureVault.isEmpty(), b -> b.key("secure_vault").value(this.secureVault)).apply(b -> {
            for (Map.Entry<String, YTreeNode> node : this.additionalSpecParameters.entrySet()) {
                b.key(node.getKey()).value(node.getValue());
            }
            return b;
        });
        return mapBuilder;
    }

    @NonNullApi
    @NonNullFields
    public static abstract class Builder<T extends Builder<T>> {
        private List<YPath> inputTables = new ArrayList<YPath>();
        private List<YPath> outputTables = new ArrayList<YPath>();
        @Nullable
        private String pool;
        @Nullable
        private String title;
        private Map<String, String> secureVault = new HashMap<String, String>();
        private Map<String, YTreeNode> outputTableAttributes = new HashMap<String, YTreeNode>();
        private Map<String, YTreeNode> additionalSpecParameters = new HashMap<String, YTreeNode>();

        public T setInputTables(Collection<YPath> inputTables) {
            this.inputTables = new ArrayList<YPath>(inputTables);
            return this.self();
        }

        public T setInputTables(YPath ... inputTables) {
            return this.setInputTables(Arrays.asList(inputTables));
        }

        public T addInputTable(YPath inputTable) {
            this.inputTables.add(inputTable);
            return this.self();
        }

        public T setOutputTables(Collection<YPath> outputTables) {
            this.outputTables = new ArrayList<YPath>(outputTables);
            return this.self();
        }

        public T setOutputTables(YPath ... inputTables) {
            return this.setOutputTables(Arrays.asList(inputTables));
        }

        public T addOutputTable(YPath outputTable) {
            this.outputTables.add(outputTable);
            return this.self();
        }

        public T setOutputTableAttributes(Map<String, YTreeNode> outputTableAttributes) {
            this.outputTableAttributes = new HashMap<String, YTreeNode>(outputTableAttributes);
            return this.self();
        }

        public T plusOutputTableAttribute(String key, @Nullable Object value) {
            YTreeNode node = new YTreeBuilder().value(value).build();
            return this.plusOutputTableAttribute(key, node);
        }

        public T plusOutputTableAttribute(String key, YTreeNode value) {
            this.outputTableAttributes.put(key, value);
            return this.self();
        }

        public T setPool(@Nullable String pool) {
            this.pool = pool;
            return this.self();
        }

        public T setTitle(@Nullable String title) {
            this.title = title;
            return this.self();
        }

        public T setSecureVault(Map<String, String> secureVault) {
            this.secureVault = new HashMap<String, String>(secureVault);
            return this.self();
        }

        public T plusSecureVault(String key, String value) {
            this.secureVault.put(key, value);
            return this.self();
        }

        public T setAdditionalSpecParameters(Map<String, YTreeNode> additionalSpecParameters) {
            this.additionalSpecParameters = new HashMap<String, YTreeNode>(additionalSpecParameters);
            return this.self();
        }

        public T plusAdditionalSpecParameter(String key, @Nullable Object value) {
            YTreeNode node = new YTreeBuilder().value(value).build();
            return this.plusAdditionalSpecParameter(key, node);
        }

        public T plusAdditionalSpecParameter(String key, YTreeNode value) {
            this.additionalSpecParameters.put(key, value);
            return this.self();
        }

        protected abstract T self();
    }
}

