/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.FormatContext;
import tech.ytsaurus.client.operations.MapperOrReducerSpec;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.VanillaJob;
import tech.ytsaurus.client.operations.VanillaMain;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class VanillaJobSpec
extends MapperOrReducerSpec
implements Spec {
    private final List<YPath> outputTablePaths;

    protected VanillaJobSpec(Builder builder) {
        super(VanillaMain.class, builder);
        this.outputTablePaths = builder.outputTablePaths;
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext, FormatContext formatContext) {
        return this.prepare(builder, yt, specPreparationContext);
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        if (this.outputTablePaths.isEmpty()) {
            FormatContext formatContext = FormatContext.builder().setOutputTableCount(0).build();
            return super.prepare(builder, yt, specPreparationContext, formatContext);
        }
        FormatContext formatContext = FormatContext.builder().setOutputTableCount(this.outputTablePaths.size()).build();
        YTreeBuilder prepare = super.prepare(YTree.builder(), yt, specPreparationContext, formatContext);
        HashMap<String, YTreeNode> node = new HashMap<String, YTreeNode>(prepare.build().asMap());
        node.put("output_table_paths", YTree.builder().value((Collection)this.outputTablePaths.stream().map(YPath::toTree).collect(Collectors.toList())).build());
        return builder.value(node);
    }

    public static Builder builder(VanillaJob<?> job) {
        Builder builder = new Builder();
        builder.setJob(job);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNullApi
    @NonNullFields
    public static class Builder
    extends MapperOrReducerSpec.Builder<Builder> {
        private List<YPath> outputTablePaths = List.of();

        Builder() {
            this.setJobCount(1);
        }

        @Override
        public VanillaJobSpec build() {
            if (this.getUserJob() == null) {
                throw new IllegalStateException("Job is required and has no default value");
            }
            return new VanillaJobSpec(this);
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setJob(VanillaJob<?> job) {
            this.setUserJob(job);
            return this;
        }

        @Override
        public Builder setJobCount(Integer jobCount) {
            if (jobCount < 1) {
                throw new IllegalArgumentException("Vanilla's job_count must be >= 1");
            }
            return (Builder)super.setJobCount(jobCount);
        }

        public Builder setOutputTablePaths(List<YPath> outputTablePaths) {
            this.outputTablePaths = outputTablePaths;
            return this;
        }
    }
}

