/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.io.IOException;
import java.io.OutputStream;
import tech.ytsaurus.client.operations.Statistics;
import tech.ytsaurus.client.operations.StatisticsImpl;
import tech.ytsaurus.client.operations.VanillaJob;
import tech.ytsaurus.client.operations.YTableEntryType;
import tech.ytsaurus.client.operations.YtMainUtils;
import tech.ytsaurus.core.operations.Yield;
import tech.ytsaurus.lang.NonNullApi;

@NonNullApi
class VanillaMain {
    private VanillaMain() {
    }

    public static void main(String[] args) throws Exception {
        YtMainUtils.setTempDir();
        YtMainUtils.disableSystemOutput();
        OutputStream[] output = YtMainUtils.buildOutputStreams(args);
        VanillaJob mapper = (VanillaJob)YtMainUtils.construct(args);
        try {
            System.exit(VanillaMain.apply(mapper, output, new StatisticsImpl()));
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    public static <TOutput> int apply(VanillaJob<TOutput> job, OutputStream[] output, Statistics statistics) throws IOException {
        YTableEntryType<TOutput> outputType = job.outputType();
        try (Statistics statistics2 = statistics;){
            int n;
            block12: {
                Yield<TOutput> yield = outputType.yield(output);
                try {
                    n = job.run(yield, statistics);
                    if (yield == null) break block12;
                }
                catch (Throwable throwable) {
                    if (yield != null) {
                        try {
                            yield.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                yield.close();
            }
            return n;
        }
    }
}

