/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TransactionalClient;
import tech.ytsaurus.client.operations.Spec;
import tech.ytsaurus.client.operations.SpecPreparationContext;
import tech.ytsaurus.client.operations.SpecUtils;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

@NonNullApi
@NonNullFields
public class VanillaSpec
implements Spec {
    private final Map<String, ? extends Spec> tasks;
    @Nullable
    private final Integer maxFailedJobCount;
    @Nullable
    private final YPath stderrTablePath;
    @Nullable
    private final Integer failOnJobRestart;
    private final Map<String, YTreeNode> additionalSpecParameters;

    protected <T extends BuilderBase<T>> VanillaSpec(BuilderBase<T> builder) {
        if (builder.tasks == null) {
            throw new IllegalArgumentException("Not null tasks was expected");
        }
        this.tasks = builder.tasks;
        this.maxFailedJobCount = builder.maxFailedJobCount;
        this.stderrTablePath = builder.stderrTablePath;
        this.failOnJobRestart = builder.failOnJobRestart;
        this.additionalSpecParameters = builder.additionalSpecParameters;
    }

    public <TSpec extends Spec> VanillaSpec(String taskName, TSpec spec) {
        this((BuilderBase)VanillaSpec.builder().setTask(taskName, spec));
    }

    public static BuilderBase<?> builder() {
        return new Builder();
    }

    public Map<String, ? extends Spec> getTasks() {
        return this.tasks;
    }

    public Optional<Integer> getMaxFailedJobCount() {
        return Optional.ofNullable(this.maxFailedJobCount);
    }

    public Optional<YPath> getStderrTablePath() {
        return Optional.ofNullable(this.stderrTablePath);
    }

    public Optional<Integer> getFailOnJobRestart() {
        return Optional.ofNullable(this.failOnJobRestart);
    }

    public Map<String, YTreeNode> getAdditionalSpecParameters() {
        return this.additionalSpecParameters;
    }

    @Override
    public YTreeBuilder prepare(YTreeBuilder builder, TransactionalClient yt, SpecPreparationContext specPreparationContext) {
        return builder.beginMap().key("tasks").beginMap().apply(b -> {
            this.tasks.forEach((k, v) -> v.prepare(b.key(k), yt, specPreparationContext));
            return b;
        }).endMap().when(this.maxFailedJobCount != null, b -> b.key("max_failed_job_count").value(this.maxFailedJobCount)).when(this.stderrTablePath != null, b -> b.key("stderr_table_path").value((Object)this.stderrTablePath)).when(this.failOnJobRestart != null, b -> b.key("fail_on_job_restart").value(this.failOnJobRestart)).key("started_by").apply(b -> SpecUtils.startedBy(b, specPreparationContext)).apply(b -> {
            for (Map.Entry<String, YTreeNode> node : this.additionalSpecParameters.entrySet()) {
                b.key(node.getKey()).value(node.getValue());
            }
            return b;
        }).endMap();
    }

    @NonNullApi
    @NonNullFields
    public static abstract class BuilderBase<T extends BuilderBase<T>> {
        @Nullable
        private Map<String, ? extends Spec> tasks;
        @Nullable
        private Integer maxFailedJobCount;
        @Nullable
        private YPath stderrTablePath;
        @Nullable
        private Integer failOnJobRestart;
        private Map<String, YTreeNode> additionalSpecParameters = new HashMap<String, YTreeNode>();

        public T setTasks(Map<String, ? extends Spec> tasks) {
            this.tasks = tasks;
            return this.self();
        }

        public <TSpec extends Spec> T setTask(String taskName, TSpec spec) {
            this.tasks = Collections.singletonMap(taskName, spec);
            return this.self();
        }

        public T setMaxFailedJobCount(Integer maxFailedJobCount) {
            this.maxFailedJobCount = maxFailedJobCount;
            return this.self();
        }

        public T setStderrTablePath(YPath stderrTablePath) {
            this.stderrTablePath = stderrTablePath;
            return this.self();
        }

        public T setFailOnJobRestart(Integer failOnJobRestart) {
            this.failOnJobRestart = failOnJobRestart;
            return this.self();
        }

        public T setAdditionalSpecParameters(Map<String, YTreeNode> additionalSpecParameters) {
            this.additionalSpecParameters = additionalSpecParameters;
            return this.self();
        }

        public VanillaSpec build() {
            return new VanillaSpec(this);
        }

        protected abstract T self();
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

