/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.operations;

import com.google.protobuf.Message;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import tech.ytsaurus.client.operations.Mapper;
import tech.ytsaurus.client.operations.MapperOrReducer;
import tech.ytsaurus.client.operations.Reducer;
import tech.ytsaurus.client.operations.ReducerWithKey;
import tech.ytsaurus.client.operations.VanillaJob;
import tech.ytsaurus.client.operations.YTableEntryType;
import tech.ytsaurus.client.operations.YTableEntryTypes;
import tech.ytsaurus.client.rows.EntityUtil;
import tech.ytsaurus.core.utils.ClassUtils;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.ysontree.YTreeMapNode;

@NonNullApi
@NonNullFields
final class YTableEntryTypeUtils {
    private static final List<Class<?>> DEFAULT_CLASSES = Arrays.asList(MapperOrReducer.class, Mapper.class, Reducer.class, ReducerWithKey.class, VanillaJob.class);

    private YTableEntryTypeUtils() {
    }

    public static <T, I, O> YTableEntryType<T> resolve(MapperOrReducer<I, O> mapperOrReducer, int genericParam) {
        Optional<Type> genericSuperclass = ClassUtils.getAllGenericInterfaces(mapperOrReducer.getClass()).stream().filter(i -> DEFAULT_CLASSES.contains(ClassUtils.erasure((Type)i))).findFirst();
        if (genericSuperclass.isPresent()) {
            List actualTypes = ClassUtils.getActualTypeArguments((Type)genericSuperclass.get());
            return YTableEntryTypeUtils.forType((Type)actualTypes.get(genericParam), mapperOrReducer.trackIndices(), YTableEntryTypeUtils.isInputType(genericParam));
        }
        throw new IllegalStateException("Can't resolve types for " + String.valueOf(mapperOrReducer));
    }

    private static boolean isInputType(int genericParam) {
        return genericParam == 0;
    }

    public static <T> YTableEntryType<T> forType(Type type, boolean trackIndices, boolean isInputType) {
        boolean actualTrackIndices;
        Class clazz = ClassUtils.erasure((Type)type);
        boolean bl = actualTrackIndices = trackIndices && isInputType;
        if (clazz.equals(YTreeMapNode.class)) {
            return (YTableEntryType)ClassUtils.castToType(YTableEntryTypes.yson(actualTrackIndices));
        }
        if (EntityUtil.isEntityAnnotationPresent(clazz)) {
            return YTableEntryTypes.entity(clazz, actualTrackIndices, isInputType);
        }
        if (Message.class.isAssignableFrom(clazz)) {
            return (YTableEntryType)ClassUtils.castToType(YTableEntryTypes.proto((Class)ClassUtils.castToType((Object)clazz), actualTrackIndices, isInputType));
        }
        throw new IllegalArgumentException("Can't resolve type for " + String.valueOf(type));
    }
}

