/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqAbortJob;

public class AbortJob
extends RequestBase<Builder, AbortJob>
implements HighLevelRequest<TReqAbortJob.Builder> {
    private final GUID jobId;
    @Nullable
    private final Duration interruptTimeout;

    public AbortJob(GUID jobId) {
        this(AbortJob.builder().setJobId(jobId));
    }

    AbortJob(Builder builder) {
        super(builder);
        this.jobId = Objects.requireNonNull(builder.jobId);
        this.interruptTimeout = builder.interruptTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqAbortJob.Builder, ?> requestBuilder) {
        TReqAbortJob.Builder messageBuilder = requestBuilder.body();
        messageBuilder.setJobId(RpcUtil.toProto(this.jobId));
        if (this.interruptTimeout != null) {
            messageBuilder.setInterruptTimeout(this.interruptTimeout.toNanos() / 1000L);
        }
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("jobId: ").append(this.jobId).append(";");
        sb.append("interruptTimeout: ").append(this.interruptTimeout).append(";");
    }

    @Override
    public Builder toBuilder() {
        Builder builder = AbortJob.builder().setJobId(this.jobId);
        if (this.interruptTimeout != null) {
            builder.setInterruptTimeout(this.interruptTimeout);
        }
        ((Builder)((Builder)((Builder)((Builder)builder.setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        return builder;
    }

    public static class Builder
    extends RequestBase.Builder<Builder, AbortJob> {
        @Nullable
        private GUID jobId;
        @Nullable
        private Duration interruptTimeout;

        Builder() {
        }

        public Builder setJobId(GUID jobId) {
            this.jobId = jobId;
            return this.self();
        }

        public Builder setInterruptTimeout(Duration interruptTimeout) {
            this.interruptTimeout = interruptTimeout;
            return this.self();
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            sb.append("jobId: ").append(this.jobId).append(";");
            sb.append("interruptTimeout: ").append(this.interruptTimeout).append(";");
        }

        @Override
        public AbortJob build() {
            return new AbortJob(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

