/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.Atomicity;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.TableReplicaMode;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqAlterTableReplica;

public class AlterTableReplica
extends RequestBase<Builder, AlterTableReplica>
implements HighLevelRequest<TReqAlterTableReplica.Builder> {
    private final GUID replicaId;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final TableReplicaMode mode;
    @Nullable
    private final Boolean preserveTimestamps;
    @Nullable
    private final Atomicity atomicity;

    AlterTableReplica(Builder builder) {
        super(builder);
        this.replicaId = Objects.requireNonNull(builder.replicaId);
        this.enabled = builder.enabled;
        this.mode = builder.mode;
        this.preserveTimestamps = builder.preserveTimestamps;
        this.atomicity = builder.atomicity;
    }

    public AlterTableReplica(GUID replicaId) {
        this(AlterTableReplica.builder().setReplicaId(replicaId));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqAlterTableReplica.Builder, ?> requestBuilder) {
        TReqAlterTableReplica.Builder builder = requestBuilder.body();
        builder.setReplicaId(RpcUtil.toProto(this.replicaId));
        if (this.enabled != null) {
            builder.setEnabled(this.enabled.booleanValue());
        }
        if (this.mode != null) {
            builder.setMode(this.mode.getProtoValue());
        }
        if (this.preserveTimestamps != null) {
            builder.setPreserveTimestamps(this.preserveTimestamps.booleanValue());
        }
        if (this.atomicity != null) {
            builder.setAtomicity(this.atomicity.getProtoValue());
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        sb.append("ReplicaId: ").append(this.replicaId).append("; ");
        if (this.enabled != null) {
            sb.append("Enabled: ").append(this.enabled).append("; ");
        }
        if (this.mode != null) {
            sb.append("Mode: ").append((Object)this.mode).append("; ");
        }
        if (this.preserveTimestamps != null) {
            sb.append("PreserveTimestamps: ").append(this.preserveTimestamps).append("; ");
        }
        if (this.atomicity != null) {
            sb.append("Atomicity: ").append((Object)this.atomicity).append("; ");
        }
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)AlterTableReplica.builder().setReplicaId(this.replicaId).setEnabled(this.enabled).setMode(this.mode).setPreserveTimestamps(this.preserveTimestamps).setAtomicity(this.atomicity).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, AlterTableReplica> {
        @Nullable
        GUID replicaId;
        @Nullable
        Boolean enabled;
        @Nullable
        TableReplicaMode mode;
        @Nullable
        Boolean preserveTimestamps;
        @Nullable
        Atomicity atomicity;

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.replicaId = builder.replicaId;
            this.enabled = builder.enabled;
            this.mode = builder.mode;
            this.preserveTimestamps = builder.preserveTimestamps;
            this.atomicity = builder.atomicity;
        }

        public Builder setReplicaId(GUID replicaId) {
            this.replicaId = replicaId;
            return this.self();
        }

        public Builder setEnabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public Builder setMode(@Nullable TableReplicaMode mode) {
            this.mode = mode;
            return this.self();
        }

        public Builder setPreserveTimestamps(@Nullable Boolean preserveTimestamps) {
            this.preserveTimestamps = preserveTimestamps;
            return this.self();
        }

        public Builder setAtomicity(@Nullable Atomicity atomicity) {
            this.atomicity = atomicity;
            return this.self();
        }

        @Override
        public AlterTableReplica build() {
            return new AlterTableReplica(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

