/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqCommitTransaction;

public class CommitTransaction
extends RequestBase<Builder, CommitTransaction>
implements HighLevelRequest<TReqCommitTransaction.Builder> {
    private final GUID transactionId;

    CommitTransaction(Builder builder) {
        super(builder);
        this.transactionId = Objects.requireNonNull(builder.transactionId);
    }

    public CommitTransaction(GUID transactionId) {
        this(CommitTransaction.builder().setTransactionId(transactionId));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqCommitTransaction.Builder, ?> builder) {
        builder.body().setTransactionId(RpcUtil.toProto(this.transactionId));
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("TransactionId: ").append(this.transactionId).append(";");
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)CommitTransaction.builder().setTransactionId(this.transactionId).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, CommitTransaction> {
        @Nullable
        private GUID transactionId;

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.transactionId = builder.transactionId;
        }

        public Builder setTransactionId(GUID transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        @Override
        public CommitTransaction build() {
            return new CommitTransaction(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

