/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.ShuffleHandle;
import tech.ytsaurus.rpcproxy.TReqWriteShuffleData;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class CreateShuffleWriter
extends RequestBase<Builder, CreateShuffleWriter> {
    private final ShuffleHandle handle;
    private final String partitionColumn;
    @Nullable
    private final YTreeNode config;
    @Nullable
    private final Integer writerIndex;
    @Nullable
    private final Boolean overwriteExistingWriterData;
    private static final YTreeNode EMPTY_CONFIG = YTree.builder().beginMap().endMap().build();
    private final long windowSize;
    private final long packetSize;

    public CreateShuffleWriter(BuilderBase<?> builder) {
        super(builder);
        this.handle = builder.handle;
        this.partitionColumn = builder.partitionColumn;
        this.config = builder.config;
        this.writerIndex = builder.writerIndex;
        this.overwriteExistingWriterData = builder.overwriteExistingWriterData;
        this.windowSize = builder.windowSize;
        this.packetSize = builder.packetSize;
    }

    public String getPartitionColumn() {
        return this.partitionColumn;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void writeTo(TReqWriteShuffleData.Builder builder) {
        builder.setSignedShuffleHandle(this.handle.getPayload());
        builder.setPartitionColumn(this.partitionColumn);
        if (this.writerIndex != null) {
            builder.setWriterIndex(this.writerIndex.intValue());
        }
        if (this.overwriteExistingWriterData != null) {
            builder.setOverwriteExistingWriterData(this.overwriteExistingWriterData.booleanValue());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        YTreeBinarySerializer.serialize((YTreeNode)(this.config == null ? EMPTY_CONFIG : this.config), (OutputStream)baos);
        byte[] data = baos.toByteArray();
        builder.setWriterConfig(ByteString.copyFrom((byte[])data));
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)CreateShuffleWriter.builder().setHandle(this.handle)).setPartitionColumn(this.partitionColumn)).setConfig(this.config)).setWriterIndex(this.writerIndex)).setOverwriteExistingWriterData(this.overwriteExistingWriterData)).setWindowSize(this.windowSize)).setPacketSize(this.packetSize);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, CreateShuffleWriter> {
        private ShuffleHandle handle;
        private String partitionColumn;
        @Nullable
        private YTreeNode config = null;
        @Nullable
        private Integer writerIndex;
        @Nullable
        private Boolean overwriteExistingWriterData;
        private long windowSize = 16000000L;
        private long packetSize = this.windowSize / 2L;

        public TBuilder setHandle(ShuffleHandle handle) {
            this.handle = handle;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPartitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setConfig(@Nullable YTreeNode config) {
            this.config = config;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setWriterIndex(@Nullable Integer writerIndex) {
            this.writerIndex = writerIndex;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setOverwriteExistingWriterData(@Nullable Boolean overwriteExistingWriterData) {
            this.overwriteExistingWriterData = overwriteExistingWriterData;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setWindowSize(long windowSize) {
            this.windowSize = windowSize;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPacketSize(long packetSize) {
            this.packetSize = packetSize;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public CreateShuffleWriter build() {
            return new CreateShuffleWriter(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

