/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MasterReadOptions;
import tech.ytsaurus.client.request.TransactionalRequest;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TMasterReadOptions;
import tech.ytsaurus.rpcproxy.TReqGetFileFromCache;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;

public class GetFileFromCache
extends TransactionalRequest<Builder, GetFileFromCache>
implements HighLevelRequest<TReqGetFileFromCache.Builder> {
    private final YPath cachePath;
    private final String md5;
    @Nullable
    private final MasterReadOptions masterReadOptions;

    GetFileFromCache(Builder builder) {
        super(builder);
        this.cachePath = Objects.requireNonNull(builder.cachePath);
        this.md5 = Objects.requireNonNull(builder.md5);
        this.masterReadOptions = builder.masterReadOptions != null ? new MasterReadOptions(builder.masterReadOptions) : null;
    }

    public GetFileFromCache(YPath cachePath, String md5) {
        this(GetFileFromCache.builder().setCachePath(cachePath).setMd5(md5));
    }

    public static Builder builder() {
        return new Builder();
    }

    public YPath getCachePath() {
        return this.cachePath;
    }

    public String getMd5() {
        return this.md5;
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqGetFileFromCache.Builder, ?> builder) {
        builder.body().setCachePath(ByteString.copyFromUtf8((String)this.cachePath.toString())).setMd5(this.md5);
        if (this.masterReadOptions != null) {
            builder.body().setMasterReadOptions(this.masterReadOptions.writeTo(TMasterReadOptions.newBuilder()));
        }
        if (this.transactionalOptions != null) {
            builder.body().setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        sb.append("CachePath: ").append(this.cachePath).append("; ");
        sb.append("Md5: ").append(this.md5).append("; ");
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)GetFileFromCache.builder().setCachePath(this.cachePath).setMd5(this.md5).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        if (this.masterReadOptions != null) {
            builder.setMasterReadOptions(this.masterReadOptions);
        }
        return builder;
    }

    public static class Builder
    extends TransactionalRequest.Builder<Builder, GetFileFromCache> {
        @Nullable
        private YPath cachePath;
        @Nullable
        private String md5;
        @Nullable
        private MasterReadOptions masterReadOptions;

        public Builder setCachePath(YPath cachePath) {
            this.cachePath = cachePath;
            return this.self();
        }

        public Builder setMd5(String md5) {
            this.md5 = md5;
            return this.self();
        }

        public Builder setMasterReadOptions(MasterReadOptions masterReadOptions) {
            this.masterReadOptions = new MasterReadOptions(masterReadOptions);
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetFileFromCache build() {
            return new GetFileFromCache(this);
        }
    }
}

