/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.rpcproxy.TReqGetTabletInfos;

public class GetTabletInfos
extends RequestBase<Builder, GetTabletInfos>
implements HighLevelRequest<TReqGetTabletInfos.Builder> {
    private final String path;
    private final List<Integer> tabletIndexes;

    GetTabletInfos(Builder builder) {
        super(builder);
        this.path = Objects.requireNonNull(builder.path);
        this.tabletIndexes = builder.tabletIndexes;
    }

    public GetTabletInfos(String path) {
        this(GetTabletInfos.builder().setPath(path));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqGetTabletInfos.Builder, ?> builder) {
        builder.body().setPath(ByteString.copyFromUtf8((String)this.path));
        builder.body().addAllTabletIndexes(this.tabletIndexes);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        sb.append("Path: ").append(this.path).append("; TabletIndexes: ").append(this.tabletIndexes).append("; ");
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)GetTabletInfos.builder().setPath(this.path).setTabletIndexes(this.tabletIndexes).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, GetTabletInfos> {
        @Nullable
        private String path;
        private List<Integer> tabletIndexes = new ArrayList<Integer>();

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.path = builder.path;
            this.tabletIndexes = new ArrayList<Integer>(builder.tabletIndexes);
        }

        public Builder setPath(String path) {
            this.path = path;
            return this.self();
        }

        public Builder addTabletIndex(int idx) {
            this.tabletIndexes.add(idx);
            return this.self();
        }

        public Builder setTabletIndexes(List<Integer> tabletIndexes) {
            this.tabletIndexes.clear();
            this.tabletIndexes.addAll(tabletIndexes);
            return this.self();
        }

        @Override
        public GetTabletInfos build() {
            return new GetTabletInfos(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

