/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.request.PreparableModifyRowsRequest;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedRowSerializer;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.client.rows.WireProtocolWriter;
import tech.ytsaurus.core.tables.ColumnSchema;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.ERowModificationType;

public class ModifyRowsRequest
extends PreparableModifyRowsRequest<Builder, ModifyRowsRequest> {
    private final List<UnversionedRow> rows;
    private final List<BuilderBase.RowMeta> unconvertedRows;

    public ModifyRowsRequest(BuilderBase<?> builder) {
        super((PreparableModifyRowsRequest.Builder<?, ?>)builder);
        this.rows = new ArrayList<UnversionedRow>(builder.rows);
        this.unconvertedRows = new ArrayList<BuilderBase.RowMeta>(builder.unconvertedRows);
    }

    public ModifyRowsRequest(String path, TableSchema schema) {
        this((BuilderBase)((Builder)ModifyRowsRequest.builder().setPath(path)).setSchema(schema));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<UnversionedRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    @Override
    public void convertValues(SerializationResolver serializationResolver) {
        for (BuilderBase.RowMeta meta : this.unconvertedRows) {
            List<?> values;
            switch (meta.type) {
                case INSERT: {
                    List<Object> list = values = meta.values != null ? meta.values : this.mapToValues(Objects.requireNonNull(meta.map), this.schema.getColumnsCount());
                    if (values.size() == this.schema.getColumns().size()) break;
                    throw new IllegalArgumentException("Number of insert columns must match number of schema columns");
                }
                case UPDATE: {
                    List<Object> list = values = meta.values != null ? meta.values : this.mapToValues(Objects.requireNonNull(meta.map), this.schema.getColumnsCount());
                    if (values.size() > this.schema.getKeyColumnsCount() && values.size() <= this.schema.getColumns().size()) break;
                    throw new IllegalArgumentException("Number of update columns must be more than the number of key columns");
                }
                case DELETE: {
                    List<Object> list = values = meta.values != null ? meta.values : this.mapToValues(Objects.requireNonNull(meta.map), this.schema.getKeyColumnsCount());
                    if (values.size() == this.schema.getKeyColumnsCount()) break;
                    throw new IllegalArgumentException("Number of delete columns must match number of key columns");
                }
                default: {
                    throw new IllegalArgumentException("unknown modification type");
                }
            }
            this.rows.add(this.convertValuesToRow(values, meta.skipMissingValues, meta.aggregate, serializationResolver));
        }
        this.unconvertedRows.clear();
    }

    private UnversionedRow convertValuesToRow(List<?> values, boolean skipMissingValues, boolean aggregate, SerializationResolver serializationResolver) {
        if (values.size() < this.schema.getKeyColumnsCount()) {
            throw new IllegalArgumentException("Number of values must be more than or equal to the number of key columns");
        }
        ArrayList<UnversionedValue> row = new ArrayList<UnversionedValue>(values.size());
        ApiServiceUtil.convertKeyColumns(row, this.schema, values, serializationResolver);
        ApiServiceUtil.convertValueColumns(row, this.schema, values, skipMissingValues, aggregate, serializationResolver);
        return new UnversionedRow(row);
    }

    private List<Object> mapToValues(final Map<String, ?> values, final int size) {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return values.get(((ColumnSchema)ModifyRowsRequest.this.schema.getColumns().get(index)).getName());
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    @Override
    public void serializeRowsetTo(List<byte[]> attachments) {
        WireProtocolWriter writer = new WireProtocolWriter(attachments);
        writer.writeUnversionedRowset(this.rows, new UnversionedRowSerializer(this.schema));
        writer.finish();
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ModifyRowsRequest.builder().setRows(this.rows)).setUnconvertedRows(this.unconvertedRows)).setPath(this.path)).setSchema(this.schema)).setRequireSyncReplica(this.requireSyncReplica)).setRowModificationTypes(this.rowModificationTypes)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends PreparableModifyRowsRequest.Builder<TBuilder, ModifyRowsRequest> {
        private final List<RowMeta> unconvertedRows = new ArrayList<RowMeta>();
        private final List<UnversionedRow> rows = new ArrayList<UnversionedRow>();

        public TBuilder addInsert(List<?> values) {
            this.unconvertedRows.add(new RowMeta(ModificationType.INSERT, values, false, false));
            this.addRowModificationType(ERowModificationType.RMT_WRITE);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addInserts(Iterable<? extends List<?>> rows) {
            for (List<?> row : rows) {
                this.addInsert(row);
            }
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addUpdate(List<?> values, boolean aggregate) {
            this.unconvertedRows.add(new RowMeta(ModificationType.UPDATE, values, true, aggregate));
            this.addRowModificationType(ERowModificationType.RMT_WRITE);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addUpdates(Iterable<? extends List<?>> rows, boolean aggregate) {
            for (List<?> row : rows) {
                this.addUpdate(row, aggregate);
            }
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addUpdate(List<?> values) {
            return this.addUpdate(values, false);
        }

        public TBuilder addUpdates(Iterable<? extends List<?>> rows) {
            return this.addUpdates(rows, false);
        }

        public TBuilder addDelete(List<?> values) {
            this.unconvertedRows.add(new RowMeta(ModificationType.DELETE, values, false, false));
            this.addRowModificationType(ERowModificationType.RMT_DELETE);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addDeletes(Iterable<? extends List<?>> keys) {
            for (List<?> key : keys) {
                this.addDelete(key);
            }
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addInsert(Map<String, ?> map) {
            this.unconvertedRows.add(new RowMeta(ModificationType.INSERT, map, false, false));
            this.addRowModificationType(ERowModificationType.RMT_WRITE);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addUpdate(Map<String, ?> map, boolean aggregate) {
            this.unconvertedRows.add(new RowMeta(ModificationType.UPDATE, map, true, aggregate));
            this.addRowModificationType(ERowModificationType.RMT_WRITE);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addUpdate(Map<String, ?> map) {
            return this.addUpdate(map, false);
        }

        public TBuilder addDelete(Map<String, ?> map) {
            this.unconvertedRows.add(new RowMeta(ModificationType.DELETE, map, false, false));
            this.addRowModificationType(ERowModificationType.RMT_DELETE);
            return (TBuilder)((BuilderBase)this.self());
        }

        TBuilder setRows(List<UnversionedRow> rows) {
            this.rows.clear();
            this.rows.addAll(rows);
            return (TBuilder)((BuilderBase)this.self());
        }

        TBuilder setUnconvertedRows(List<RowMeta> rows) {
            this.unconvertedRows.clear();
            this.unconvertedRows.addAll(rows);
            return (TBuilder)((BuilderBase)this.self());
        }

        static class RowMeta {
            ModificationType type;
            boolean skipMissingValues;
            boolean aggregate;
            @Nullable
            List<?> values;
            @Nullable
            Map<String, ?> map;

            RowMeta(ModificationType type, List<?> values, boolean skipMissingValues, boolean aggregate) {
                this.type = type;
                this.values = values;
                this.skipMissingValues = skipMissingValues;
                this.aggregate = aggregate;
            }

            RowMeta(ModificationType type, Map<String, ?> map, boolean skipMissingValues, boolean aggregate) {
                this.type = type;
                this.map = map;
                this.skipMissingValues = skipMissingValues;
                this.aggregate = aggregate;
            }
        }

        static enum ModificationType {
            UPDATE("update"),
            INSERT("insert"),
            DELETE("delete");

            final String value;

            private ModificationType(String value) {
                this.value = value;
            }
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ModifyRowsRequest build() {
            return new ModifyRowsRequest(this);
        }
    }
}

