/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MultiLookupRowsSubrequest;
import tech.ytsaurus.client.request.ReplicaConsistency;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.rpcproxy.TReqMultiLookup;

public class MultiLookupRowsRequest
extends RequestBase<Builder, MultiLookupRowsRequest> {
    @Nullable
    protected final YtTimestamp timestamp;
    @Nullable
    protected final YtTimestamp retentionTimestamp;
    @Nullable
    protected final ReplicaConsistency replicaConsistency;
    protected final List<MultiLookupRowsSubrequest> subrequests;

    protected MultiLookupRowsRequest(BuilderBase<?> builder) {
        super(builder);
        this.timestamp = builder.timestamp;
        this.retentionTimestamp = builder.retentionTimestamp;
        this.replicaConsistency = builder.replicaConsistency;
        this.subrequests = builder.subrequests;
    }

    public MultiLookupRowsRequest() {
        this(MultiLookupRowsRequest.builder());
    }

    public Optional<YtTimestamp> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public Optional<YtTimestamp> getRetentionTimestamp() {
        return Optional.ofNullable(this.retentionTimestamp);
    }

    public Optional<ReplicaConsistency> getReplicaConsistency() {
        return Optional.ofNullable(this.replicaConsistency);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<MultiLookupRowsSubrequest> getSubrequests() {
        return this.subrequests;
    }

    public HighLevelRequest<TReqMultiLookup.Builder> asMultiLookupWritable() {
        return new HighLevelRequest<TReqMultiLookup.Builder>(){

            @Override
            public String getArgumentsLogString() {
                return MultiLookupRowsRequest.this.getArgumentsLogString();
            }

            @Override
            public void writeHeaderTo(TRequestHeader.Builder header) {
                MultiLookupRowsRequest.this.writeHeaderTo(header);
            }

            @Override
            public void writeTo(RpcClientRequestBuilder<TReqMultiLookup.Builder, ?> builder) {
                if (MultiLookupRowsRequest.this.getTimestamp().isPresent()) {
                    builder.body().setTimestamp(MultiLookupRowsRequest.this.getTimestamp().get().getValue());
                }
                if (MultiLookupRowsRequest.this.getRetentionTimestamp().isPresent()) {
                    builder.body().setRetentionTimestamp(MultiLookupRowsRequest.this.getRetentionTimestamp().get().getValue());
                }
                if (MultiLookupRowsRequest.this.getReplicaConsistency().isPresent()) {
                    builder.body().setReplicaConsistency(MultiLookupRowsRequest.this.getReplicaConsistency().get().getProtoValue());
                }
                for (MultiLookupRowsSubrequest subrequest : MultiLookupRowsRequest.this.subrequests) {
                    subrequest.asMultiLookupRowsSubrequestWritable().writeTo(builder);
                }
            }
        };
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)MultiLookupRowsRequest.builder().setTimestamp(this.timestamp)).setRetentionTimestamp(this.retentionTimestamp)).setReplicaConsistency(this.replicaConsistency)).setSubrequests(this.subrequests)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, MultiLookupRowsRequest> {
        @Nullable
        private YtTimestamp timestamp;
        @Nullable
        private YtTimestamp retentionTimestamp;
        @Nullable
        private ReplicaConsistency replicaConsistency;
        private List<MultiLookupRowsSubrequest> subrequests = new ArrayList<MultiLookupRowsSubrequest>();

        public TBuilder setTimestamp(@Nullable YtTimestamp timestamp) {
            this.timestamp = timestamp;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setRetentionTimestamp(@Nullable YtTimestamp retentionTimestamp) {
            this.retentionTimestamp = retentionTimestamp;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setReplicaConsistency(@Nullable ReplicaConsistency replicaConsistency) {
            this.replicaConsistency = replicaConsistency;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addSubrequest(MultiLookupRowsSubrequest multiLookupRowsSubrequest) {
            this.subrequests.add(multiLookupRowsSubrequest);
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSubrequests(List<MultiLookupRowsSubrequest> multiLookupRowsSubrequests) {
            this.subrequests = multiLookupRowsSubrequests;
            return (TBuilder)((BuilderBase)this.self());
        }

        public Optional<YtTimestamp> getTimestamp() {
            return Optional.ofNullable(this.timestamp);
        }

        public Optional<YtTimestamp> getRetentionTimestamp() {
            return Optional.ofNullable(this.retentionTimestamp);
        }

        public Optional<ReplicaConsistency> getReplicaConsistency() {
            return Optional.ofNullable(this.replicaConsistency);
        }

        public List<MultiLookupRowsSubrequest> getSubrequests() {
            return this.subrequests;
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiLookupRowsRequest build() {
            return new MultiLookupRowsRequest(this);
        }
    }
}

