/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.ChunkSliceFetcherConfig;
import tech.ytsaurus.client.request.FetchChunkSpecConfig;
import tech.ytsaurus.client.request.FetcherConfig;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.PartitionTablesMode;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.DataSize;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.EPartitionTablesMode;
import tech.ytsaurus.rpcproxy.TFetchChunkSpecConfig;
import tech.ytsaurus.rpcproxy.TFetcherConfig;
import tech.ytsaurus.rpcproxy.TReqPartitionTables;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;

public class PartitionTables
extends RequestBase<Builder, PartitionTables>
implements HighLevelRequest<TReqPartitionTables.Builder> {
    private final List<YPath> paths;
    @Nullable
    private final FetchChunkSpecConfig fetchChunkSpecConfig;
    @Nullable
    private final FetcherConfig fetcherConfig;
    @Nullable
    private final ChunkSliceFetcherConfig chunkSliceFetcherConfig;
    private final PartitionTablesMode partitionMode;
    private final DataSize dataWeightPerPartition;
    @Nullable
    private final Integer maxPartitionCount;
    @Nullable
    private final Boolean adjustDataWeightPerPartition;
    @Nullable
    private final Boolean enableKeyGuarantee;
    @Nullable
    private final TransactionalOptions transactionalOptions;

    PartitionTables(Builder builder) {
        super(builder);
        this.paths = new ArrayList<YPath>((Collection)Objects.requireNonNull(builder.paths));
        this.chunkSliceFetcherConfig = builder.chunkSliceFetcherConfig;
        this.fetchChunkSpecConfig = builder.fetchChunkSpecConfig;
        this.fetcherConfig = builder.fetcherConfig;
        this.partitionMode = Objects.requireNonNull(builder.partitionMode);
        this.dataWeightPerPartition = Objects.requireNonNull(builder.dataWeightPerPartition);
        this.maxPartitionCount = builder.maxPartitionCount;
        this.adjustDataWeightPerPartition = builder.adjustDataWeightPerPartition;
        this.enableKeyGuarantee = builder.enableKeyGuarantee;
        this.transactionalOptions = builder.transactionalOptions != null ? new TransactionalOptions(builder.transactionalOptions) : null;
    }

    public PartitionTables(List<YPath> paths, PartitionTablesMode partitionMode, DataSize dataWeightPerPartition) {
        this(PartitionTables.builder().setPaths(paths).setPartitionMode(partitionMode).setDataWeightPerPartition(dataWeightPerPartition));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqPartitionTables.Builder, ?> requestBuilder) {
        TReqPartitionTables.Builder builder = requestBuilder.body();
        for (YPath path : this.paths) {
            builder.addPaths(ByteString.copyFromUtf8((String)path.toString()));
        }
        if (this.chunkSliceFetcherConfig != null) {
            builder.setChunkSliceFetcherConfig(this.chunkSliceFetcherConfig.writeTo(TReqPartitionTables.TChunkSliceFetcherConfig.newBuilder()));
        }
        if (this.fetchChunkSpecConfig != null) {
            builder.setFetchChunkSpecConfig(this.fetchChunkSpecConfig.writeTo(TFetchChunkSpecConfig.newBuilder()));
        }
        if (this.fetcherConfig != null) {
            builder.setFetcherConfig(this.fetcherConfig.writeTo(TFetcherConfig.newBuilder()));
        }
        builder.setPartitionMode(EPartitionTablesMode.forNumber((int)this.partitionMode.getProtoValue()));
        builder.setDataWeightPerPartition(this.dataWeightPerPartition.toBytes());
        if (this.maxPartitionCount != null) {
            builder.setMaxPartitionCount(this.maxPartitionCount.intValue());
        }
        if (this.adjustDataWeightPerPartition != null) {
            builder.setAdjustDataWeightPerPartition(this.adjustDataWeightPerPartition.booleanValue());
        }
        if (this.enableKeyGuarantee != null) {
            builder.setEnableKeyGuarantee(this.enableKeyGuarantee.booleanValue());
        }
        if (this.transactionalOptions != null) {
            builder.setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("Paths: ").append(Arrays.toString(this.paths.toArray()));
        sb.append("; PartitionMode: ").append(this.partitionMode.getName());
        sb.append("; DataWeightPerPartition: ").append(this.dataWeightPerPartition);
        if (this.maxPartitionCount != null) {
            sb.append("; MaxPartitionCount: ").append(this.maxPartitionCount);
            sb.append("; AdjustDataWeightPerPartition: ").append(this.adjustDataWeightPerPartition);
        }
        sb.append(";");
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)PartitionTables.builder().setPaths(this.paths).setChunkSliceFetcherConfig(this.chunkSliceFetcherConfig).setFetchChunkSpecConfig(this.fetchChunkSpecConfig).setFetcherConfig(this.fetcherConfig).setPartitionMode(this.partitionMode).setDataWeightPerPartition(this.dataWeightPerPartition).setMaxPartitionCount(this.maxPartitionCount).setAdjustDataWeightPerPartition(this.adjustDataWeightPerPartition).setEnableKeyGuarantee(this.enableKeyGuarantee).setTransactionalOptions(this.transactionalOptions).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, PartitionTables> {
        @Nullable
        private List<YPath> paths;
        @Nullable
        private FetchChunkSpecConfig fetchChunkSpecConfig;
        @Nullable
        private FetcherConfig fetcherConfig;
        @Nullable
        private ChunkSliceFetcherConfig chunkSliceFetcherConfig;
        @Nullable
        private PartitionTablesMode partitionMode;
        @Nullable
        private DataSize dataWeightPerPartition;
        @Nullable
        private Integer maxPartitionCount;
        @Nullable
        private Boolean adjustDataWeightPerPartition = true;
        @Nullable
        private Boolean enableKeyGuarantee;
        @Nullable
        private TransactionalOptions transactionalOptions;

        public Builder setPaths(List<YPath> paths) {
            this.paths = paths;
            return this.self();
        }

        public Builder setPaths(YPath ... paths) {
            this.setPaths(Arrays.asList(paths));
            return this.self();
        }

        public Builder setFetchChunkSpecConfig(@Nullable FetchChunkSpecConfig fetchChunkSpecConfig) {
            this.fetchChunkSpecConfig = fetchChunkSpecConfig;
            return this.self();
        }

        public Builder setFetcherConfig(@Nullable FetcherConfig fetcherConfig) {
            this.fetcherConfig = fetcherConfig;
            return this.self();
        }

        public Builder setChunkSliceFetcherConfig(@Nullable ChunkSliceFetcherConfig chunkSliceFetcherConfig) {
            this.chunkSliceFetcherConfig = chunkSliceFetcherConfig;
            return this.self();
        }

        public Builder setPartitionMode(PartitionTablesMode mode) {
            this.partitionMode = mode;
            return this.self();
        }

        public Builder setDataWeightPerPartition(DataSize dataWeightPerPartition) {
            this.dataWeightPerPartition = dataWeightPerPartition;
            return this.self();
        }

        public Builder setMaxPartitionCount(@Nullable Integer maxPartitionCount) {
            this.maxPartitionCount = maxPartitionCount;
            return this.self();
        }

        public Builder setAdjustDataWeightPerPartition(@Nullable Boolean adjustDataWeightPerPartition) {
            this.adjustDataWeightPerPartition = adjustDataWeightPerPartition;
            return this.self();
        }

        public Builder setEnableKeyGuarantee(@Nullable Boolean enableKeyGuarantee) {
            this.enableKeyGuarantee = enableKeyGuarantee;
            return this.self();
        }

        public Builder setTransactionalOptions(@Nullable TransactionalOptions transactionalOptions) {
            this.transactionalOptions = transactionalOptions;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PartitionTables build() {
            return new PartitionTables(this);
        }
    }
}

