/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqPingTransaction;

public class PingTransaction
extends RequestBase<Builder, PingTransaction>
implements HighLevelRequest<TReqPingTransaction.Builder> {
    private final GUID transactionId;
    private final boolean pingAncestors;

    public PingTransaction(GUID transactionId) {
        this(PingTransaction.builder().setTransactionId(transactionId));
    }

    PingTransaction(Builder builder) {
        super(builder);
        this.transactionId = Objects.requireNonNull(builder.transactionId);
        this.pingAncestors = builder.pingAncestors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean getPingAncestors() {
        return this.pingAncestors;
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqPingTransaction.Builder, ?> builder) {
        builder.body().setTransactionId(RpcUtil.toProto(this.transactionId));
        if (this.pingAncestors != TReqPingTransaction.getDefaultInstance().getPingAncestors()) {
            builder.body().setPingAncestors(this.pingAncestors);
        }
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("TransactionId: ").append(this.transactionId).append(";");
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)PingTransaction.builder().setTransactionId(this.transactionId).setPingAncestors(this.pingAncestors).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, PingTransaction> {
        @Nullable
        private GUID transactionId;
        private boolean pingAncestors = TReqPingTransaction.getDefaultInstance().getPingAncestors();

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.transactionId = builder.transactionId;
            this.pingAncestors = builder.pingAncestors;
        }

        public Builder setTransactionId(GUID transactionId) {
            this.transactionId = transactionId;
            return this.self();
        }

        public Builder setPingAncestors(boolean pingAncestors) {
            this.pingAncestors = pingAncestors;
            return this.self();
        }

        @Override
        public PingTransaction build() {
            return new PingTransaction(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

