/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.ReplicaConsistency;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.RowBatchReadOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TReqPullQueueConsumer;

public class PullConsumer
extends RequestBase<Builder, PullConsumer>
implements HighLevelRequest<TReqPullQueueConsumer.Builder> {
    private final YPath consumerPath;
    private final YPath queuePath;
    private final int partitionIndex;
    private final RowBatchReadOptions rowBatchReadOptions;
    @Nullable
    private final Long offset;
    @Nullable
    private final ReplicaConsistency replicaConsistency;

    PullConsumer(Builder builder) {
        super(builder);
        this.consumerPath = Objects.requireNonNull(builder.consumerPath);
        this.queuePath = Objects.requireNonNull(builder.queuePath);
        this.partitionIndex = Objects.requireNonNull(builder.partitionIndex);
        this.rowBatchReadOptions = Objects.requireNonNull(builder.rowBatchReadOptions);
        this.offset = builder.offset;
        this.replicaConsistency = builder.replicaConsistency;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)PullConsumer.builder().setConsumerPath(this.consumerPath).setQueuePath(this.queuePath).setPartitionIndex(this.partitionIndex).setOffset(this.offset).setRowBatchReadOptions(this.rowBatchReadOptions).setReplicaConsistency(this.replicaConsistency).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqPullQueueConsumer.Builder, ?> requestBuilder) {
        TReqPullQueueConsumer.Builder builder = requestBuilder.body();
        builder.setConsumerPath(ByteString.copyFromUtf8((String)this.consumerPath.toString()));
        builder.setQueuePath(ByteString.copyFromUtf8((String)this.queuePath.toString()));
        builder.setPartitionIndex(this.partitionIndex);
        builder.setRowBatchReadOptions(this.rowBatchReadOptions.toProto());
        if (this.offset != null) {
            builder.setOffset(this.offset.longValue());
        }
        if (this.replicaConsistency != null) {
            builder.setReplicaConsistency(this.replicaConsistency.getProtoValue());
        }
    }

    public static class Builder
    extends RequestBase.Builder<Builder, PullConsumer> {
        @Nullable
        private YPath consumerPath;
        @Nullable
        private YPath queuePath;
        @Nullable
        private Long offset;
        @Nullable
        private Integer partitionIndex;
        private RowBatchReadOptions rowBatchReadOptions = RowBatchReadOptions.builder().build();
        @Nullable
        private ReplicaConsistency replicaConsistency;

        private Builder() {
        }

        public Builder setConsumerPath(YPath consumerPath) {
            this.consumerPath = consumerPath;
            return this.self();
        }

        public Builder setQueuePath(YPath queuePath) {
            this.queuePath = queuePath;
            return this.self();
        }

        public Builder setOffset(@Nullable Long offset) {
            this.offset = offset;
            return this.self();
        }

        public Builder setPartitionIndex(int partitionIndex) {
            this.partitionIndex = partitionIndex;
            return this.self();
        }

        public Builder setRowBatchReadOptions(RowBatchReadOptions options) {
            this.rowBatchReadOptions = options;
            return this.self();
        }

        public Builder setReplicaConsistency(@Nullable ReplicaConsistency replicaConsistency) {
            this.replicaConsistency = replicaConsistency;
            return this.self();
        }

        @Override
        public PullConsumer build() {
            return new PullConsumer(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

