/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.MasterReadOptions;
import tech.ytsaurus.client.request.MutateNode;
import tech.ytsaurus.client.request.MutatingOptions;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.rpcproxy.TMasterReadOptions;
import tech.ytsaurus.rpcproxy.TMutatingOptions;
import tech.ytsaurus.rpcproxy.TPrerequisiteOptions;
import tech.ytsaurus.rpcproxy.TReqPutFileToCache;
import tech.ytsaurus.rpcproxy.TTransactionalOptions;

public class PutFileToCache
extends MutateNode<Builder, PutFileToCache>
implements HighLevelRequest<TReqPutFileToCache.Builder> {
    private final YPath filePath;
    private final YPath cachePath;
    private final String md5;
    @Nullable
    private final Boolean preserveExpirationTimeout;
    @Nullable
    private final MasterReadOptions masterReadOptions;

    PutFileToCache(Builder builder) {
        super(builder);
        if (builder.filePath == null) {
            throw new IllegalArgumentException("filePath should be not null");
        }
        if (builder.cachePath == null) {
            throw new IllegalArgumentException("cachePath should be not null");
        }
        if (builder.md5 == null) {
            throw new IllegalArgumentException("md5 should be not null");
        }
        this.filePath = builder.filePath;
        this.cachePath = builder.cachePath;
        this.md5 = builder.md5;
        this.preserveExpirationTimeout = builder.preserveExpirationTimeout;
        this.masterReadOptions = builder.masterReadOptions != null ? new MasterReadOptions(builder.masterReadOptions) : null;
    }

    public PutFileToCache(YPath filePath, YPath cachePath, String md5) {
        this(PutFileToCache.builder().setFilePath(filePath).setCachePath(cachePath).setMd5(md5));
    }

    public static Builder builder() {
        return new Builder();
    }

    public YPath getFilePath() {
        return this.filePath;
    }

    public YPath getCachePath() {
        return this.cachePath;
    }

    public String getMd5() {
        return this.md5;
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqPutFileToCache.Builder, ?> builder) {
        builder.body().setPath(ByteString.copyFromUtf8((String)this.filePath.toString())).setCachePath(ByteString.copyFromUtf8((String)this.cachePath.toString())).setMd5(this.md5);
        if (this.masterReadOptions != null) {
            builder.body().setMasterReadOptions(this.masterReadOptions.writeTo(TMasterReadOptions.newBuilder()));
        }
        if (this.transactionalOptions != null) {
            builder.body().setTransactionalOptions(this.transactionalOptions.writeTo(TTransactionalOptions.newBuilder()));
        }
        if (this.prerequisiteOptions != null) {
            builder.body().setPrerequisiteOptions(this.prerequisiteOptions.writeTo(TPrerequisiteOptions.newBuilder()));
        }
        builder.body().setMutatingOptions(this.mutatingOptions.writeTo(TMutatingOptions.newBuilder()));
        if (this.preserveExpirationTimeout != null) {
            builder.body().setPreserveExpirationTimeout(this.preserveExpirationTimeout.booleanValue());
        }
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        sb.append("Path: ").append(this.filePath).append("; ");
        sb.append("CachePath: ").append(this.cachePath).append("; ");
        sb.append("Md5: ").append(this.md5).append("; ");
        if (this.preserveExpirationTimeout != null) {
            sb.append("PreserveExpirationTimeout: ").append(this.preserveExpirationTimeout).append("; ");
        }
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)PutFileToCache.builder().setFilePath(this.filePath).setCachePath(this.cachePath).setMd5(this.md5).setPreserveExpirationTimeout(this.preserveExpirationTimeout).setTransactionalOptions(this.transactionalOptions != null ? new TransactionalOptions(this.transactionalOptions) : null)).setPrerequisiteOptions(this.prerequisiteOptions != null ? new PrerequisiteOptions(this.prerequisiteOptions) : null)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        if (this.masterReadOptions != null) {
            builder.setMasterReadOptions(new MasterReadOptions(this.masterReadOptions));
        }
        builder.setMutatingOptions(new MutatingOptions(this.mutatingOptions));
        return builder;
    }

    public static class Builder
    extends MutateNode.Builder<Builder, PutFileToCache> {
        @Nullable
        private YPath filePath;
        @Nullable
        private YPath cachePath;
        @Nullable
        private String md5;
        @Nullable
        private Boolean preserveExpirationTimeout;
        @Nullable
        private MasterReadOptions masterReadOptions;

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.filePath = builder.filePath;
            this.cachePath = builder.cachePath;
            this.md5 = builder.md5;
            this.preserveExpirationTimeout = builder.preserveExpirationTimeout;
            if (builder.masterReadOptions != null) {
                this.masterReadOptions = new MasterReadOptions(builder.masterReadOptions);
            }
        }

        public Builder setFilePath(YPath filePath) {
            this.filePath = filePath;
            return this.self();
        }

        public Builder setCachePath(YPath cachePath) {
            this.cachePath = cachePath;
            return this.self();
        }

        public Builder setMd5(String md5) {
            this.md5 = md5;
            return this.self();
        }

        public Builder setPreserveExpirationTimeout(Boolean preserveExpirationTimeout) {
            this.preserveExpirationTimeout = preserveExpirationTimeout;
            return this.self();
        }

        public Builder setMasterReadOptions(MasterReadOptions masterReadOptions) {
            this.masterReadOptions = masterReadOptions;
            return this.self();
        }

        @Override
        public PutFileToCache build() {
            return new PutFileToCache(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

