/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.rpcproxy.EContentType;
import tech.ytsaurus.rpcproxy.TReqStartQuery;

public class QueryFile {
    private final String name;
    private final String content;
    private final ContentType type;

    private QueryFile(Builder builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.content = Objects.requireNonNull(builder.content);
        this.type = Objects.requireNonNull(builder.type);
    }

    public TReqStartQuery.TQueryFile toProto() {
        TReqStartQuery.TQueryFile.Builder builder = TReqStartQuery.TQueryFile.newBuilder();
        builder.setName(this.name);
        builder.setContent(this.content);
        builder.setType(this.type.getProtoValue());
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ContentType {
        RawInlineData(EContentType.CT_RAW_INLINE_DATA, "raw_inline_data"),
        Url(EContentType.CT_URL, "url");

        private final EContentType protoValue;
        private final String stringValue;

        private ContentType(EContentType protoValue, String stringValue) {
            this.protoValue = protoValue;
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }

        EContentType getProtoValue() {
            return this.protoValue;
        }
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private String content;
        @Nullable
        private ContentType type;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setContentType(ContentType contentType) {
            this.type = contentType;
            return this;
        }

        public QueryFile build() {
            return new QueryFile(this);
        }
    }
}

