/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import NYT.NChunkClient.NProto.DataStatistics;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.client.ApiServiceUtil;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.TRspGetQueryResult;
import tech.ytsaurus.ysontree.YTreeNode;

public class QueryResult {
    private final GUID queryId;
    private final long resultIndex;
    private final YTsaurusError error;
    @Nullable
    private final TableSchema schema;
    private final DataStatistics.TDataStatistics dataStatistics;
    private final boolean isTruncated;
    @Nullable
    private final YTreeNode fullResult;

    public QueryResult(TRspGetQueryResult rsp) {
        this.queryId = RpcUtil.fromProto((TGuidOrBuilder)rsp.getQueryId());
        this.resultIndex = rsp.getResultIndex();
        this.error = new YTsaurusError(rsp.getError());
        this.schema = rsp.hasSchema() ? ApiServiceUtil.deserializeTableSchema(rsp.getSchema()) : null;
        this.dataStatistics = rsp.getDataStatistics();
        this.isTruncated = rsp.getIsTruncated();
        this.fullResult = rsp.hasFullResult() ? RpcUtil.parseByteString(rsp.getFullResult()) : null;
    }

    public GUID getQueryId() {
        return this.queryId;
    }

    public long getResultIndex() {
        return this.resultIndex;
    }

    public YTsaurusError getError() {
        return this.error;
    }

    public Optional<TableSchema> getSchema() {
        return Optional.ofNullable(this.schema);
    }

    public DataStatistics.TDataStatistics getDataStatistics() {
        return this.dataStatistics;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public Optional<YTreeNode> fullResult() {
        return Optional.ofNullable(this.fullResult);
    }
}

