/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.rpcproxy.TQueryStatistics;

public class QueryStatistics {
    @Nullable
    private final Long rowsRead;
    @Nullable
    private final Long dataWeightRead;
    @Nullable
    private final Long rowsWritten;
    @Nullable
    private final Duration syncTime;
    @Nullable
    private final Duration asyncTime;
    @Nullable
    private final Duration executeTime;
    @Nullable
    private final Duration readTime;
    @Nullable
    private final Duration writeTime;
    @Nullable
    private final Duration codegenTime;
    @Nullable
    private final Duration waitOnReadyEventTime;
    private final boolean incompleteInput;
    private final boolean incompleteOutput;
    @Nullable
    private final Long memoryUsage;
    @Nullable
    private final Long totalGroupedRowCount;
    private final List<QueryStatistics> innerStatistics;

    public QueryStatistics(TQueryStatistics stats) {
        this.rowsRead = stats.hasRowsRead() ? Long.valueOf(stats.getRowsRead()) : null;
        this.dataWeightRead = stats.hasDataWeightRead() ? Long.valueOf(stats.getDataWeightRead()) : null;
        this.rowsWritten = stats.hasRowsWritten() ? Long.valueOf(stats.getRowsWritten()) : null;
        this.syncTime = stats.hasSyncTime() ? RpcUtil.durationFromMicros(stats.getSyncTime()) : null;
        this.asyncTime = stats.hasAsyncTime() ? RpcUtil.durationFromMicros(stats.getAsyncTime()) : null;
        this.executeTime = stats.hasExecuteTime() ? RpcUtil.durationFromMicros(stats.getExecuteTime()) : null;
        this.readTime = stats.hasReadTime() ? RpcUtil.durationFromMicros(stats.getReadTime()) : null;
        this.writeTime = stats.hasWriteTime() ? RpcUtil.durationFromMicros(stats.getWriteTime()) : null;
        this.codegenTime = stats.hasCodegenTime() ? RpcUtil.durationFromMicros(stats.getCodegenTime()) : null;
        this.waitOnReadyEventTime = stats.hasWaitOnReadyEventTime() ? RpcUtil.durationFromMicros(stats.getWaitOnReadyEventTime()) : null;
        this.incompleteInput = stats.getIncompleteInput();
        this.incompleteOutput = stats.getIncompleteOutput();
        this.memoryUsage = stats.hasMemoryUsage() ? Long.valueOf(stats.getMemoryUsage()) : null;
        this.totalGroupedRowCount = stats.hasTotalGroupedRowCount() ? Long.valueOf(stats.getTotalGroupedRowCount()) : null;
        this.innerStatistics = stats.getInnerStatisticsList().stream().map(QueryStatistics::new).collect(Collectors.toUnmodifiableList());
    }

    public Optional<Long> getRowsRead() {
        return Optional.ofNullable(this.rowsRead);
    }

    public Optional<Long> getDataWeightRead() {
        return Optional.ofNullable(this.dataWeightRead);
    }

    public Optional<Long> getRowsWritten() {
        return Optional.ofNullable(this.rowsWritten);
    }

    public Optional<Duration> getSyncTime() {
        return Optional.ofNullable(this.syncTime);
    }

    public Optional<Duration> getAsyncTime() {
        return Optional.ofNullable(this.asyncTime);
    }

    public Optional<Duration> getExecuteTime() {
        return Optional.ofNullable(this.executeTime);
    }

    public Optional<Duration> getReadTime() {
        return Optional.ofNullable(this.readTime);
    }

    public Optional<Duration> getWriteTime() {
        return Optional.ofNullable(this.writeTime);
    }

    public Optional<Duration> getCodegenTime() {
        return Optional.ofNullable(this.codegenTime);
    }

    public Optional<Duration> getWaitOnReadyEventTime() {
        return Optional.ofNullable(this.waitOnReadyEventTime);
    }

    public boolean isInputIncomplete() {
        return this.incompleteInput;
    }

    public boolean isOutputIncomplete() {
        return this.incompleteOutput;
    }

    public Optional<Long> getMemoryUsage() {
        return Optional.ofNullable(this.memoryUsage);
    }

    public Optional<Long> getTotalGroupedRowCount() {
        return Optional.ofNullable(this.totalGroupedRowCount);
    }

    public List<QueryStatistics> getInnerStatistics() {
        return this.innerStatistics;
    }
}

