/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.QueryTrackerReq;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqReadQueryResult;

public class ReadQueryResult
extends QueryTrackerReq<Builder, ReadQueryResult>
implements HighLevelRequest<TReqReadQueryResult.Builder> {
    private final GUID queryId;
    private final long resultIndex;
    @Nullable
    private final List<String> columns;
    @Nullable
    private final Long lowerRowIndex;
    @Nullable
    private final Long upperRowIndex;

    ReadQueryResult(Builder builder) {
        super(builder);
        this.queryId = Objects.requireNonNull(builder.queryId);
        this.resultIndex = Objects.requireNonNull(builder.resultIndex);
        this.columns = builder.columns;
        this.lowerRowIndex = builder.lowerRowIndex;
        this.upperRowIndex = builder.upperRowIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)ReadQueryResult.builder().setQueryId(this.queryId).setResultIndex(this.resultIndex).setColumns(this.columns).setLowerRowIndex(this.lowerRowIndex).setUpperRowIndex(this.upperRowIndex).setQueryTrackerStage(this.queryTrackerStage)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqReadQueryResult.Builder, ?> requestBuilder) {
        TReqReadQueryResult.Builder builder = requestBuilder.body();
        this.writeQueryTrackerDescriptionToProto(arg_0 -> ((TReqReadQueryResult.Builder)builder).setQueryTrackerStage(arg_0));
        builder.setQueryId(RpcUtil.toProto(this.queryId));
        builder.setResultIndex(this.resultIndex);
        if (this.columns != null) {
            builder.setColumns(TReqReadQueryResult.TColumns.newBuilder().addAllItems(this.columns).build());
        }
        if (this.lowerRowIndex != null) {
            builder.setLowerRowIndex(this.lowerRowIndex.longValue());
        }
        if (this.upperRowIndex != null) {
            builder.setUpperRowIndex(this.upperRowIndex.longValue());
        }
    }

    public static class Builder
    extends QueryTrackerReq.Builder<Builder, ReadQueryResult> {
        @Nullable
        private GUID queryId;
        @Nullable
        private Long resultIndex;
        @Nullable
        private List<String> columns;
        @Nullable
        private Long lowerRowIndex;
        @Nullable
        private Long upperRowIndex;

        private Builder() {
        }

        public Builder setQueryId(GUID queryId) {
            this.queryId = queryId;
            return this.self();
        }

        public Builder setResultIndex(long resultIndex) {
            this.resultIndex = resultIndex;
            return this.self();
        }

        public Builder setColumns(@Nullable List<String> columns) {
            this.columns = columns;
            return this.self();
        }

        public Builder setLowerRowIndex(@Nullable Long lowerRowIndex) {
            this.lowerRowIndex = lowerRowIndex;
            return this.self();
        }

        public Builder setUpperRowIndex(@Nullable Long upperRowIndex) {
            this.upperRowIndex = upperRowIndex;
            return this.self();
        }

        @Override
        public ReadQueryResult build() {
            return new ReadQueryResult(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

