/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.ReplicaConsistency;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.YtTimestamp;
import tech.ytsaurus.rpcproxy.TReqSelectRows;
import tech.ytsaurus.ysontree.YTreeMapNode;

public class SelectRowsRequest
extends RequestBase<Builder, SelectRowsRequest>
implements HighLevelRequest<TReqSelectRows.Builder> {
    private final String query;
    @Nullable
    private final YtTimestamp timestamp;
    @Nullable
    private final YtTimestamp retentionTimestamp;
    @Nullable
    private final Long inputRowsLimit;
    @Nullable
    private final Long outputRowsLimit;
    @Nullable
    private final Boolean failOnIncompleteResult;
    @Nullable
    private final Integer maxSubqueries;
    @Nullable
    private final Boolean allowJoinWithoutIndex;
    @Nullable
    private final String udfRegistryPath;
    @Nullable
    private final String executionPool;
    @Nullable
    private final Boolean allowFullScan;
    @Nullable
    private final Long rangeExpansionLimit;
    @Nullable
    private final Boolean useCanonicalNullRelations;
    @Nullable
    private final ReplicaConsistency replicaConsistency;
    @Nullable
    private final YTreeMapNode placeholderValues;

    public SelectRowsRequest(BuilderBase<?> builder) {
        super(builder);
        this.query = Objects.requireNonNull(builder.query);
        this.timestamp = builder.timestamp;
        this.retentionTimestamp = builder.retentionTimestamp;
        this.inputRowsLimit = builder.inputRowsLimit;
        this.outputRowsLimit = builder.outputRowsLimit;
        this.failOnIncompleteResult = builder.failOnIncompleteResult;
        this.maxSubqueries = builder.maxSubqueries;
        this.allowJoinWithoutIndex = builder.allowJoinWithoutIndex;
        this.udfRegistryPath = builder.udfRegistryPath;
        this.executionPool = builder.executionPool;
        this.allowFullScan = builder.allowFullScan;
        this.rangeExpansionLimit = builder.rangeExpansionLimit;
        this.useCanonicalNullRelations = builder.useCanonicalNullRelations;
        this.replicaConsistency = builder.replicaConsistency;
        this.placeholderValues = builder.placeholderValues;
    }

    private SelectRowsRequest(String query) {
        this((BuilderBase<?>)SelectRowsRequest.builder().setQuery(query));
    }

    public static SelectRowsRequest of(String query) {
        return new SelectRowsRequest(query);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getQuery() {
        return this.query;
    }

    public Optional<YtTimestamp> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public Optional<YtTimestamp> getRetentionTimestamp() {
        return Optional.ofNullable(this.retentionTimestamp);
    }

    public OptionalLong getInputRowsLimit() {
        return this.inputRowsLimit == null ? OptionalLong.empty() : OptionalLong.of(this.inputRowsLimit);
    }

    public Optional<Boolean> getFailOnIncompleteResult() {
        return Optional.ofNullable(this.failOnIncompleteResult);
    }

    public OptionalLong getOutputRowsLimit() {
        return this.outputRowsLimit == null ? OptionalLong.empty() : OptionalLong.of(this.outputRowsLimit);
    }

    public OptionalInt getMaxSubqueries() {
        return this.maxSubqueries == null ? OptionalInt.empty() : OptionalInt.of(this.maxSubqueries);
    }

    public Optional<Boolean> getAllowJoinWithoutIndex() {
        return Optional.ofNullable(this.allowJoinWithoutIndex);
    }

    public Optional<String> getUdfRegistryPath() {
        return Optional.ofNullable(this.udfRegistryPath);
    }

    public Optional<String> getExecutionPool() {
        return Optional.ofNullable(this.executionPool);
    }

    public Optional<Boolean> getAllowFullScan() {
        return Optional.ofNullable(this.allowFullScan);
    }

    public Optional<Long> getRangeExpansionLimit() {
        return Optional.ofNullable(this.rangeExpansionLimit);
    }

    public Optional<Boolean> getUseCanonicalNullRelations() {
        return Optional.ofNullable(this.useCanonicalNullRelations);
    }

    public Optional<ReplicaConsistency> getReplicaConsistency() {
        return Optional.ofNullable(this.replicaConsistency);
    }

    public Optional<YTreeMapNode> getPlaceholderValues() {
        return Optional.ofNullable(this.placeholderValues);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqSelectRows.Builder, ?> builder) {
        builder.body().setQuery(this.getQuery());
        if (this.getTimestamp().isPresent()) {
            builder.body().setTimestamp(this.getTimestamp().get().getValue());
        }
        if (this.getRetentionTimestamp().isPresent()) {
            builder.body().setRetentionTimestamp(this.getRetentionTimestamp().get().getValue());
        }
        if (this.getInputRowsLimit().isPresent()) {
            builder.body().setInputRowLimit(this.getInputRowsLimit().getAsLong());
        }
        if (this.getOutputRowsLimit().isPresent()) {
            builder.body().setOutputRowLimit(this.getOutputRowsLimit().getAsLong());
        }
        if (this.getFailOnIncompleteResult().isPresent()) {
            builder.body().setFailOnIncompleteResult(this.getFailOnIncompleteResult().get().booleanValue());
        }
        if (this.getMaxSubqueries().isPresent()) {
            builder.body().setMaxSubqueries(this.getMaxSubqueries().getAsInt());
        }
        if (this.getAllowJoinWithoutIndex().isPresent()) {
            builder.body().setAllowJoinWithoutIndex(this.getAllowJoinWithoutIndex().get().booleanValue());
        }
        if (this.getUdfRegistryPath().isPresent()) {
            builder.body().setUdfRegistryPath(ByteString.copyFromUtf8((String)this.getUdfRegistryPath().get()));
        }
        if (this.getExecutionPool().isPresent()) {
            builder.body().setExecutionPool(this.getExecutionPool().get());
        }
        if (this.getAllowFullScan().isPresent()) {
            builder.body().setAllowFullScan(this.getAllowFullScan().get().booleanValue());
        }
        if (this.getRangeExpansionLimit().isPresent()) {
            builder.body().setRangeExpansionLimit(this.getRangeExpansionLimit().get().longValue());
        }
        if (this.getUseCanonicalNullRelations().isPresent()) {
            builder.body().setUseCanonicalNullRelations(this.getUseCanonicalNullRelations().get().booleanValue());
        }
        if (this.getReplicaConsistency().isPresent()) {
            builder.body().setReplicaConsistency(this.getReplicaConsistency().get().getProtoValue());
        }
        if (this.getPlaceholderValues().isPresent()) {
            builder.body().setPlaceholderValues(ByteString.copyFrom((byte[])this.getPlaceholderValues().get().toBinary()));
        }
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        sb.append("Query: ").append(this.query).append("; ");
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)SelectRowsRequest.builder().setQuery(this.query)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        if (this.timestamp != null) {
            builder.setTimestamp(this.timestamp);
        }
        if (this.retentionTimestamp != null) {
            builder.setRetentionTimestamp(this.retentionTimestamp);
        }
        if (this.inputRowsLimit != null) {
            builder.setInputRowsLimit(this.inputRowsLimit);
        }
        if (this.outputRowsLimit != null) {
            builder.setOutputRowsLimit(this.outputRowsLimit);
        }
        if (this.failOnIncompleteResult != null) {
            builder.setFailOnIncompleteResult(this.failOnIncompleteResult);
        }
        if (this.maxSubqueries != null) {
            builder.setMaxSubqueries(this.maxSubqueries);
        }
        if (this.allowJoinWithoutIndex != null) {
            builder.setAllowJoinWithoutIndex(this.allowJoinWithoutIndex);
        }
        if (this.udfRegistryPath != null) {
            builder.setUdfRegistryPath(this.udfRegistryPath);
        }
        if (this.executionPool != null) {
            builder.setExecutionPool(this.executionPool);
        }
        if (this.allowFullScan != null) {
            builder.setAllowFullScan(this.allowFullScan);
        }
        if (this.rangeExpansionLimit != null) {
            builder.setRangeExpansionLimit(this.rangeExpansionLimit);
        }
        if (this.useCanonicalNullRelations != null) {
            builder.setUseCanonicalNullRelations(this.useCanonicalNullRelations);
        }
        if (this.replicaConsistency != null) {
            builder.setReplicaConsistency(this.replicaConsistency);
        }
        if (this.placeholderValues != null) {
            builder.setPlaceholderValues(this.placeholderValues);
        }
        return builder;
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends RequestBase.Builder<TBuilder, SelectRowsRequest> {
        @Nullable
        private String query;
        @Nullable
        private YtTimestamp timestamp;
        @Nullable
        private YtTimestamp retentionTimestamp;
        @Nullable
        private Long inputRowsLimit;
        @Nullable
        private Long outputRowsLimit;
        @Nullable
        private Boolean failOnIncompleteResult;
        @Nullable
        private Integer maxSubqueries;
        @Nullable
        private Boolean allowJoinWithoutIndex;
        @Nullable
        private String udfRegistryPath;
        @Nullable
        private String executionPool;
        @Nullable
        private Boolean allowFullScan;
        @Nullable
        private Long rangeExpansionLimit;
        @Nullable
        private Boolean useCanonicalNullRelations;
        @Nullable
        private ReplicaConsistency replicaConsistency;
        @Nullable
        YTreeMapNode placeholderValues;

        public BuilderBase() {
        }

        BuilderBase(BuilderBase<?> builder) {
            super(builder);
            this.query = builder.query;
            this.timestamp = builder.timestamp;
            this.retentionTimestamp = builder.retentionTimestamp;
            this.inputRowsLimit = builder.inputRowsLimit;
            this.outputRowsLimit = builder.outputRowsLimit;
            this.failOnIncompleteResult = builder.failOnIncompleteResult;
            this.maxSubqueries = builder.maxSubqueries;
            this.allowJoinWithoutIndex = builder.allowJoinWithoutIndex;
            this.udfRegistryPath = builder.udfRegistryPath;
            this.executionPool = builder.executionPool;
            this.allowFullScan = builder.allowFullScan;
            this.rangeExpansionLimit = builder.rangeExpansionLimit;
            this.useCanonicalNullRelations = builder.useCanonicalNullRelations;
            this.replicaConsistency = builder.replicaConsistency;
            this.placeholderValues = builder.placeholderValues;
        }

        public TBuilder setQuery(String query) {
            this.query = query;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setTimestamp(YtTimestamp timestamp) {
            this.timestamp = timestamp;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setRetentionTimestamp(YtTimestamp retentionTimestamp) {
            this.retentionTimestamp = retentionTimestamp;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setInputRowsLimit(long inputRowsLimit) {
            this.inputRowsLimit = inputRowsLimit;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setOutputRowsLimit(long outputRowsLimit) {
            this.outputRowsLimit = outputRowsLimit;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setFailOnIncompleteResult(boolean failOnIncompleteResult) {
            this.failOnIncompleteResult = failOnIncompleteResult;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setMaxSubqueries(int maxSubqueries) {
            this.maxSubqueries = maxSubqueries;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAllowJoinWithoutIndex(boolean allowJoinWithoutIndex) {
            this.allowJoinWithoutIndex = allowJoinWithoutIndex;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setUdfRegistryPath(String udfRegistryPath) {
            this.udfRegistryPath = udfRegistryPath;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setExecutionPool(String executionPool) {
            this.executionPool = executionPool;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAllowFullScan(boolean allowFullScan) {
            this.allowFullScan = allowFullScan;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setRangeExpansionLimit(long rangeExpansionLimit) {
            this.rangeExpansionLimit = rangeExpansionLimit;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setUseCanonicalNullRelations(boolean useCanonicalNullRelations) {
            this.useCanonicalNullRelations = useCanonicalNullRelations;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setReplicaConsistency(ReplicaConsistency replicaConsistency) {
            this.replicaConsistency = replicaConsistency;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setPlaceholderValues(YTreeMapNode placeholderValues) {
            this.placeholderValues = placeholderValues;
            return (TBuilder)((BuilderBase)this.self());
        }

        public String getQuery() {
            return Objects.requireNonNull(this.query);
        }

        public Optional<YtTimestamp> getTimestamp() {
            return Optional.ofNullable(this.timestamp);
        }

        public Optional<YtTimestamp> getRetentionTimestamp() {
            return Optional.ofNullable(this.retentionTimestamp);
        }

        public OptionalLong getInputRowsLimit() {
            return this.inputRowsLimit == null ? OptionalLong.empty() : OptionalLong.of(this.inputRowsLimit);
        }

        public Optional<Boolean> getFailOnIncompleteResult() {
            return Optional.ofNullable(this.failOnIncompleteResult);
        }

        public OptionalLong getOutputRowsLimit() {
            return this.outputRowsLimit == null ? OptionalLong.empty() : OptionalLong.of(this.outputRowsLimit);
        }

        public OptionalInt getMaxSubqueries() {
            return this.maxSubqueries == null ? OptionalInt.empty() : OptionalInt.of(this.maxSubqueries);
        }

        public Optional<Boolean> getAllowJoinWithoutIndex() {
            return Optional.ofNullable(this.allowJoinWithoutIndex);
        }

        public Optional<String> getUdfRegistryPath() {
            return Optional.ofNullable(this.udfRegistryPath);
        }

        public Optional<String> getExecutionPool() {
            return Optional.ofNullable(this.executionPool);
        }

        public Optional<Boolean> getAllowFullScan() {
            return Optional.ofNullable(this.allowFullScan);
        }

        public Optional<Long> getRangeExpansionLimit() {
            return Optional.ofNullable(this.rangeExpansionLimit);
        }

        public Optional<Boolean> getUseCanonicalNullRelations() {
            return Optional.ofNullable(this.useCanonicalNullRelations);
        }

        public Optional<ReplicaConsistency> getReplicaConsistency() {
            return Optional.ofNullable(this.replicaConsistency);
        }

        public Optional<YTreeMapNode> getPlaceholderValues() {
            return Optional.ofNullable(this.placeholderValues);
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            sb.append("Query: ").append(this.query).append("; ");
        }

        @Override
        public SelectRowsRequest build() {
            return new SelectRowsRequest(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }
}

