/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.Message;
import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TableAttachmentReader;
import tech.ytsaurus.client.TableRowsSerializer;
import tech.ytsaurus.client.request.Format;
import tech.ytsaurus.client.rows.EntitySkiffSerializer;
import tech.ytsaurus.client.rows.EntityUtil;
import tech.ytsaurus.client.rows.WireRowSerializer;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.core.rows.YTreeSerializer;
import tech.ytsaurus.core.utils.ClassUtils;
import tech.ytsaurus.core.utils.ProtoUtils;
import tech.ytsaurus.rpcproxy.ERowsetFormat;

public class SerializationContext<T> {
    @Nullable
    protected WireRowSerializer<T> wireSerializer;
    @Nullable
    protected YTreeSerializer<T> ytreeSerializer;
    @Nullable
    private EntitySkiffSerializer<T> skiffSerializer;
    @Nullable
    private Class<T> objectClass;
    protected ERowsetFormat rowsetFormat = ERowsetFormat.RF_YT_WIRE;
    @Nullable
    protected Format format = null;
    @Nullable
    protected TableAttachmentReader<T> attachmentReader = null;
    @Nullable
    protected TableRowsSerializer<T> tableRowsSerializer;

    protected SerializationContext() {
    }

    public SerializationContext(YTreeSerializer<T> serializer, Format format) {
        if (!(serializer instanceof YTreeRowSerializer)) {
            throw new IllegalArgumentException("YTreeRowSerializer was expected");
        }
        this.ytreeSerializer = serializer;
        this.rowsetFormat = ERowsetFormat.RF_FORMAT;
        this.format = format;
    }

    public SerializationContext(Class<T> objectClass) {
        this.objectClass = objectClass;
        if (EntityUtil.isEntityAnnotationPresent(objectClass)) {
            this.skiffSerializer = new EntitySkiffSerializer<T>(objectClass);
            this.rowsetFormat = ERowsetFormat.RF_FORMAT;
            this.attachmentReader = TableAttachmentReader.skiff(this.skiffSerializer);
            return;
        }
        if (Message.class.isAssignableFrom(objectClass)) {
            Message.Builder messageBuilder = ProtoUtils.newBuilder((Class)((Class)ClassUtils.castToType(objectClass)));
            this.rowsetFormat = ERowsetFormat.RF_FORMAT;
            this.format = Format.protobuf(messageBuilder);
            this.attachmentReader = (TableAttachmentReader)ClassUtils.castToType(TableAttachmentReader.protobuf(messageBuilder));
        }
    }

    public SerializationContext(YTreeSerializer<T> serializer) {
        this.ytreeSerializer = serializer;
    }

    public Optional<WireRowSerializer<T>> getWireSerializer() {
        return Optional.ofNullable(this.wireSerializer);
    }

    public Optional<YTreeSerializer<T>> getYtreeSerializer() {
        return Optional.ofNullable(this.ytreeSerializer);
    }

    public Optional<EntitySkiffSerializer<T>> getSkiffSerializer() {
        return Optional.ofNullable(this.skiffSerializer);
    }

    public Optional<Class<T>> getObjectClass() {
        return Optional.ofNullable(this.objectClass);
    }

    public ERowsetFormat getRowsetFormat() {
        return this.rowsetFormat;
    }

    public Optional<Format> getFormat() {
        if (this.skiffSerializer != null) {
            return this.skiffSerializer.getFormat();
        }
        return Optional.ofNullable(this.format);
    }

    public Optional<TableAttachmentReader<T>> getAttachmentReader() {
        return Optional.ofNullable(this.attachmentReader);
    }

    public Optional<TableRowsSerializer<T>> getTableRowsSerializer() {
        return Optional.ofNullable(this.tableRowsSerializer);
    }

    public boolean isProtobufFormat() {
        return this.objectClass != null && Message.class.isAssignableFrom(this.objectClass);
    }
}

