/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import java.util.Optional;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.PrerequisiteOptions;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.request.TransactionalOptions;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.ysontree.YTreeBuilder;

public abstract class TransactionalRequest<TBuilder extends RequestBase.Builder<TBuilder, TRequest>, TRequest extends RequestBase<TBuilder, TRequest>>
extends RequestBase<TBuilder, TRequest> {
    @Nullable
    protected TransactionalOptions transactionalOptions;
    @Nullable
    protected PrerequisiteOptions prerequisiteOptions;

    TransactionalRequest(Builder<?, ?> builder) {
        super(builder);
        this.transactionalOptions = builder.transactionalOptions;
        this.prerequisiteOptions = builder.prerequisiteOptions;
    }

    protected TransactionalRequest(TransactionalRequest<?, ?> other) {
        super(other);
        if (other.transactionalOptions != null) {
            this.transactionalOptions = new TransactionalOptions(other.transactionalOptions);
        }
        if (other.prerequisiteOptions != null) {
            this.prerequisiteOptions = new PrerequisiteOptions(other.prerequisiteOptions);
        }
    }

    public Optional<TransactionalOptions> getTransactionalOptions() {
        return Optional.ofNullable(this.transactionalOptions);
    }

    public Optional<PrerequisiteOptions> getPrerequisiteOptions() {
        return Optional.ofNullable(this.prerequisiteOptions);
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        if (this.transactionalOptions != null) {
            this.transactionalOptions.writeArgumentsLogString(sb);
        }
    }

    YTreeBuilder toTree(YTreeBuilder builder) {
        if (this.prerequisiteOptions != null) {
            builder = this.prerequisiteOptions.toTree(builder);
        }
        if (this.transactionalOptions != null) {
            builder = this.transactionalOptions.toTree(builder);
        }
        return builder;
    }

    public static abstract class Builder<TBuilder extends Builder<TBuilder, TRequest>, TRequest extends TransactionalRequest<?, TRequest>>
    extends RequestBase.Builder<TBuilder, TRequest> {
        @Nullable
        protected TransactionalOptions transactionalOptions;
        @Nullable
        protected PrerequisiteOptions prerequisiteOptions;

        Builder() {
        }

        protected Builder(Builder<?, ?> other) {
            super(other);
            if (other.transactionalOptions != null) {
                this.transactionalOptions = new TransactionalOptions(other.transactionalOptions);
            }
            if (other.prerequisiteOptions != null) {
                this.prerequisiteOptions = new PrerequisiteOptions(other.prerequisiteOptions);
            }
        }

        public TBuilder setTransactionalOptionsOfTransactionId(GUID transactionId) {
            this.transactionalOptions = new TransactionalOptions(transactionId);
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setTransactionalOptions(@Nullable TransactionalOptions to) {
            this.transactionalOptions = to;
            return (TBuilder)((Builder)this.self());
        }

        public TBuilder setPrerequisiteOptions(@Nullable PrerequisiteOptions prerequisiteOptions) {
            this.prerequisiteOptions = prerequisiteOptions;
            return (TBuilder)((Builder)this.self());
        }

        public Optional<TransactionalOptions> getTransactionalOptions() {
            return Optional.ofNullable(this.transactionalOptions);
        }

        public Optional<PrerequisiteOptions> getPrerequisiteOptions() {
            return Optional.ofNullable(this.prerequisiteOptions);
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            if (this.transactionalOptions != null) {
                this.transactionalOptions.writeArgumentsLogString(sb);
            }
        }

        protected YTreeBuilder toTree(YTreeBuilder builder) {
            if (this.prerequisiteOptions != null) {
                builder = this.prerequisiteOptions.toTree(builder);
            }
            if (this.transactionalOptions != null) {
                builder = this.transactionalOptions.toTree(builder);
            }
            return builder;
        }
    }
}

