/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.RequestBase;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.rpcproxy.TReqTrimTable;

public class TrimTable
extends RequestBase<Builder, TrimTable>
implements HighLevelRequest<TReqTrimTable.Builder> {
    private final String path;
    private final int tabletIndex;
    private final long trimmedRowCount;

    TrimTable(Builder builder) {
        super(builder);
        this.path = Objects.requireNonNull(builder.path);
        this.tabletIndex = Objects.requireNonNull(builder.tabletIndex);
        this.trimmedRowCount = Objects.requireNonNull(builder.trimmedRowCount);
    }

    public TrimTable(String path, int tabletIndex, long trimmedRowCount) {
        this(TrimTable.builder().setPath(path).setTabletIndex(tabletIndex).setTrimmedRowCount(trimmedRowCount));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqTrimTable.Builder, ?> builder) {
        builder.body().setPath(ByteString.copyFromUtf8((String)this.path));
        builder.body().setTabletIndex(this.tabletIndex);
        builder.body().setTrimmedRowCount(this.trimmedRowCount);
    }

    @Override
    protected void writeArgumentsLogString(@Nonnull StringBuilder sb) {
        sb.append("Path: ").append(this.path).append("; TabletIndex: ").append(this.tabletIndex).append("; TrimmedRowCount: ").append(this.trimmedRowCount).append("; ");
        super.writeArgumentsLogString(sb);
    }

    @Override
    public Builder toBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)TrimTable.builder().setPath(this.path).setTabletIndex(this.tabletIndex).setTrimmedRowCount(this.trimmedRowCount).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
    }

    public static class Builder
    extends RequestBase.Builder<Builder, TrimTable> {
        @Nullable
        private String path;
        @Nullable
        private Integer tabletIndex;
        @Nullable
        private Long trimmedRowCount;

        Builder() {
        }

        Builder(Builder builder) {
            super(builder);
            this.path = builder.path;
            this.tabletIndex = builder.tabletIndex;
            this.trimmedRowCount = builder.trimmedRowCount;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this.self();
        }

        public Builder setTabletIndex(int tabletIndex) {
            this.tabletIndex = tabletIndex;
            return this.self();
        }

        public Builder setTrimmedRowCount(long trimmedRowCount) {
            this.trimmedRowCount = trimmedRowCount;
            return this.self();
        }

        @Override
        public TrimTable build() {
            return new TrimTable(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

