/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.request;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.HighLevelRequest;
import tech.ytsaurus.client.request.OperationReq;
import tech.ytsaurus.client.rpc.RpcClientRequestBuilder;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.TReqUpdateOperationParameters;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonTextWriter;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;

public class UpdateOperationParameters
extends OperationReq<Builder, UpdateOperationParameters>
implements HighLevelRequest<TReqUpdateOperationParameters.Builder> {
    @Nullable
    private final List<String> owners;
    @Nullable
    private final String pool;
    @Nullable
    private final Map<String, SchedulingOptions> schedulingOptionsPerPoolTree;
    @Nullable
    private final Double weight;
    @Nullable
    private final YTreeNode annotations;

    public UpdateOperationParameters(BuilderBase<?> builder) {
        super((OperationReq.Builder<?, ?>)builder);
        this.owners = builder.owners != null ? new ArrayList<String>(builder.owners) : null;
        this.pool = builder.pool;
        this.schedulingOptionsPerPoolTree = builder.schedulingOptionsPerPoolTree != null ? new HashMap<String, SchedulingOptions>(builder.schedulingOptionsPerPoolTree) : null;
        this.weight = builder.weight;
        this.annotations = builder.annotations;
    }

    public UpdateOperationParameters(GUID guid) {
        this((BuilderBase)UpdateOperationParameters.builder().setOperationId(guid));
    }

    UpdateOperationParameters(String alias) {
        this((BuilderBase)UpdateOperationParameters.builder().setOperationAlias(alias));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateOperationParameters fromAlias(String alias) {
        return new UpdateOperationParameters(alias);
    }

    @Override
    public void writeTo(RpcClientRequestBuilder<TReqUpdateOperationParameters.Builder, ?> requestBuilder) {
        TReqUpdateOperationParameters.Builder messageBuilder = requestBuilder.body();
        this.writeOperationDescriptionToProto(arg_0 -> ((TReqUpdateOperationParameters.Builder)messageBuilder).setOperationId(arg_0), arg_0 -> ((TReqUpdateOperationParameters.Builder)messageBuilder).setOperationAlias(arg_0));
        YTreeMapNode parameters = this.toTreeParametersOnly(YTree.mapBuilder()).buildMap();
        messageBuilder.setParameters(ByteString.copyFrom((byte[])parameters.toBinary()));
    }

    @Override
    public YTreeBuilder toTree(YTreeBuilder builder) {
        builder = super.toTree(builder);
        builder = this.toTreeParametersOnly(builder.key("parameters").beginMap()).endMap();
        return builder;
    }

    YTreeBuilder toTreeParametersOnly(YTreeBuilder builder) {
        if (this.owners != null) {
            YTreeBuilder lb = YTree.listBuilder();
            for (String string : this.owners) {
                lb.value(string);
            }
            builder.key("owners").value((YTreeNode)lb.buildList());
        }
        if (this.pool != null) {
            builder.key("pool").value(this.pool);
        }
        if (this.schedulingOptionsPerPoolTree != null) {
            YTreeBuilder mb = YTree.mapBuilder();
            for (Map.Entry entry : this.schedulingOptionsPerPoolTree.entrySet()) {
                mb.key((String)entry.getKey()).value(((SchedulingOptions)entry.getValue()).toYTreeNode());
            }
            builder.key("scheduling_options_per_pool_tree").value((YTreeNode)mb.buildMap());
        }
        if (this.weight != null) {
            builder.key("weight").value(this.weight);
        }
        if (this.annotations != null) {
            builder.key("annotations").value(this.annotations);
        }
        return builder;
    }

    public YTreeMapNode toTreeParametersOnly() {
        return this.toTreeParametersOnly(YTree.mapBuilder()).buildMap();
    }

    @Override
    protected void writeArgumentsLogString(StringBuilder sb) {
        super.writeArgumentsLogString(sb);
        YTreeMapNode parameters = this.toTreeParametersOnly(YTree.mapBuilder()).buildMap();
        try (YsonTextWriter writer = new YsonTextWriter(sb);){
            sb.append("Parameters: ");
            YTreeNodeUtils.walk((YTreeNode)parameters, (YsonConsumer)writer, (boolean)false, (boolean)true);
            sb.append("; ");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateOperationParameters(");
        this.writeArgumentsLogString(sb);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)UpdateOperationParameters.builder().setOperationId(this.operationId)).setOperationAlias(this.operationAlias)).setTimeout(this.timeout)).setRequestId(this.requestId)).setUserAgent(this.userAgent)).setTraceId(this.traceId, this.traceSampled)).setAdditionalData(this.additionalData);
        if (this.owners != null) {
            builder.setOwners(this.owners);
        }
        if (this.schedulingOptionsPerPoolTree != null) {
            builder.setSchedulingOptionsPerPoolTree(this.schedulingOptionsPerPoolTree);
        }
        if (this.weight != null) {
            builder.setWeight(this.weight);
        }
        if (this.pool != null) {
            builder.setPool(this.pool);
        }
        if (this.annotations != null) {
            builder.setAnnotations(this.annotations);
        }
        return builder;
    }

    public static abstract class BuilderBase<TBuilder extends BuilderBase<TBuilder>>
    extends OperationReq.Builder<TBuilder, UpdateOperationParameters> {
        @Nullable
        private List<String> owners;
        @Nullable
        private String pool;
        @Nullable
        private Map<String, SchedulingOptions> schedulingOptionsPerPoolTree;
        @Nullable
        private Double weight;
        @Nullable
        private YTreeNode annotations;

        public TBuilder setOwners(List<String> owners) {
            this.owners = owners;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setOwners(String ... owners) {
            return this.setOwners(Arrays.asList(owners));
        }

        public TBuilder setPool(String pool) {
            this.pool = pool;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setSchedulingOptionsPerPoolTree(Map<String, SchedulingOptions> schedulingOptionsPerPoolTree) {
            this.schedulingOptionsPerPoolTree = new HashMap<String, SchedulingOptions>();
            for (Map.Entry<String, SchedulingOptions> entry : schedulingOptionsPerPoolTree.entrySet()) {
                this.schedulingOptionsPerPoolTree.put(entry.getKey(), new SchedulingOptions(entry.getValue()));
            }
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder addSchedulingOptions(String pool, SchedulingOptions schedulingOptions) {
            if (this.schedulingOptionsPerPoolTree == null) {
                this.schedulingOptionsPerPoolTree = new HashMap<String, SchedulingOptions>();
            }
            this.schedulingOptionsPerPoolTree.put(pool, new SchedulingOptions(schedulingOptions));
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setWeight(double weight) {
            this.weight = weight;
            return (TBuilder)((BuilderBase)this.self());
        }

        public TBuilder setAnnotations(YTreeNode annotations) {
            this.annotations = annotations;
            return (TBuilder)((BuilderBase)this.self());
        }

        @Override
        public YTreeBuilder toTree(YTreeBuilder builder) {
            builder = super.toTree(builder);
            builder = this.toTreeParametersOnly(builder.key("parameters").beginMap()).endMap();
            return builder;
        }

        YTreeBuilder toTreeParametersOnly(YTreeBuilder builder) {
            if (this.owners != null) {
                YTreeBuilder lb = YTree.listBuilder();
                for (String string : this.owners) {
                    lb.value(string);
                }
                builder.key("owners").value((YTreeNode)lb.buildList());
            }
            if (this.pool != null) {
                builder.key("pool").value(this.pool);
            }
            if (this.schedulingOptionsPerPoolTree != null) {
                YTreeBuilder mb = YTree.mapBuilder();
                for (Map.Entry entry : this.schedulingOptionsPerPoolTree.entrySet()) {
                    mb.key((String)entry.getKey()).value(((SchedulingOptions)entry.getValue()).toYTreeNode());
                }
                builder.key("scheduling_options_per_pool_tree").value((YTreeNode)mb.buildMap());
            }
            if (this.weight != null) {
                builder.key("weight").value(this.weight);
            }
            if (this.annotations != null) {
                builder.key("annotations").value(this.annotations);
            }
            return builder;
        }

        public YTreeMapNode toTreeParametersOnly() {
            return this.toTreeParametersOnly(YTree.mapBuilder()).buildMap();
        }

        @Override
        protected void writeArgumentsLogString(StringBuilder sb) {
            super.writeArgumentsLogString(sb);
            YTreeMapNode parameters = this.toTreeParametersOnly(YTree.mapBuilder()).buildMap();
            try (YsonTextWriter writer = new YsonTextWriter(sb);){
                sb.append("Parameters: ");
                YTreeNodeUtils.walk((YTreeNode)parameters, (YsonConsumer)writer, (boolean)false, (boolean)true);
                sb.append("; ");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UpdateOperationParameters(");
            this.writeArgumentsLogString(sb);
            sb.append(")");
            return sb.toString();
        }

        @Override
        public UpdateOperationParameters build() {
            return new UpdateOperationParameters(this);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }

    public static class ResourceLimits {
        @Nullable
        private Long userSlots;
        @Nullable
        private Double cpu;
        @Nullable
        private Long network;
        @Nullable
        private Long memory;

        public ResourceLimits() {
        }

        public ResourceLimits(ResourceLimits other) {
            this.userSlots = other.userSlots;
            this.cpu = other.cpu;
            this.network = other.network;
            this.memory = other.memory;
        }

        public ResourceLimits(@Nullable Long userSlots, @Nullable Double cpu, @Nullable Long network, @Nullable Long memory) {
            this.userSlots = userSlots;
            this.cpu = cpu;
            this.network = network;
            this.memory = memory;
        }

        public ResourceLimits setUserSlots(long userSlots) {
            this.userSlots = userSlots;
            return this;
        }

        public ResourceLimits setCpu(double cpu) {
            this.cpu = cpu;
            return this;
        }

        public ResourceLimits setNetwork(long network) {
            this.network = network;
            return this;
        }

        public ResourceLimits setMemory(long memory) {
            this.memory = memory;
            return this;
        }

        private YTreeNode toYTreeNode() {
            YTreeBuilder b = YTree.mapBuilder();
            if (this.userSlots != null) {
                b.key("user_slots").value(this.userSlots);
            }
            if (this.cpu != null) {
                b.key("cpu").value(this.cpu);
            }
            if (this.network != null) {
                b.key("network").value(this.network);
            }
            if (this.memory != null) {
                b.key("memory").value(this.memory);
            }
            return b.buildMap();
        }
    }

    public static class SchedulingOptions {
        @Nullable
        private Double weight;
        @Nullable
        private ResourceLimits resourceLimits;

        public SchedulingOptions() {
        }

        public SchedulingOptions(SchedulingOptions other) {
            this.weight = other.weight;
            this.resourceLimits = other.resourceLimits != null ? new ResourceLimits(other.resourceLimits) : null;
        }

        public SchedulingOptions(@Nullable Double weight, @Nullable ResourceLimits resourceLimits) {
            this.weight = weight;
            this.resourceLimits = resourceLimits;
        }

        public SchedulingOptions setWeight(double weight) {
            this.weight = weight;
            return this;
        }

        public SchedulingOptions setResourceLimits(ResourceLimits resourceLimits) {
            this.resourceLimits = resourceLimits;
            return this;
        }

        private YTreeNode toYTreeNode() {
            YTreeBuilder b = YTree.mapBuilder();
            if (this.weight != null) {
                b.key("weight").value(this.weight);
            }
            if (this.resourceLimits != null) {
                b.key("resource_limits").value(this.resourceLimits.toYTreeNode());
            }
            return b.buildMap();
        }
    }
}

