/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

public class Bitmap {
    private final long[] bitmap;
    private final int bitCount;

    public Bitmap(int bitCount) {
        this.bitmap = new long[Bitmap.computeChunkCount(bitCount)];
        this.bitCount = bitCount;
    }

    public static int computeChunkCount(int bitCount) {
        return (bitCount + 63) / 64;
    }

    public boolean getBit(int index) {
        if (index < 0 || index >= this.bitCount) {
            throw new IndexOutOfBoundsException();
        }
        int chunkIndex = index >> 6;
        return (this.bitmap[chunkIndex] & 1L << (index & 0x3F)) != 0L;
    }

    public void setBit(int index) {
        int chunkIndex;
        if (index < 0 || index >= this.bitCount) {
            throw new IndexOutOfBoundsException();
        }
        int n = chunkIndex = index >> 6;
        this.bitmap[n] = this.bitmap[n] | 1L << (index & 0x3F);
    }

    public void clearBit(int index) {
        int chunkIndex;
        if (index < 0 || index >= this.bitCount) {
            throw new IndexOutOfBoundsException();
        }
        int n = chunkIndex = index >> 6;
        this.bitmap[n] = this.bitmap[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void setBit(int index, boolean value) {
        if (value) {
            this.setBit(index);
        } else {
            this.clearBit(index);
        }
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public long getChunk(int index) {
        return this.bitmap[index];
    }

    public void setChunk(int index, long value) {
        this.bitmap[index] = value;
    }

    public int getChunkCount() {
        return this.bitmap.length;
    }
}

