/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import tech.ytsaurus.client.rows.ChunkedWriterMarker;

public class ChunkedWriter {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final int MIN_CHUNK_SIZE = 1024;
    static final int MAX_CHUNK_SIZE = 0x10000000;
    private final List<byte[]> output;
    private final int maxChunkSize;
    private final ChunkedWriterMarker marker;
    private byte[] buffer;
    private int offset;

    public ChunkedWriter() {
        this(new ArrayList<byte[]>());
    }

    public ChunkedWriter(List<byte[]> output) {
        this(output, 0);
    }

    public ChunkedWriter(List<byte[]> output, int initialReserveSize) {
        this(output, initialReserveSize, 0x10000000);
    }

    ChunkedWriter(List<byte[]> output, int initialReserveSize, int limitChunkSize) {
        this.maxChunkSize = Math.min(Math.max(limitChunkSize, 1024), 0x10000000);
        this.marker = new ChunkedWriterMarker();
        initialReserveSize = ChunkedWriter.minPowerOfTwo(initialReserveSize);
        if (initialReserveSize > this.maxChunkSize || initialReserveSize < 0) {
            initialReserveSize = this.maxChunkSize;
        }
        this.output = output;
        this.buffer = initialReserveSize > 0 ? new byte[initialReserveSize] : EMPTY_BUFFER;
        this.offset = 0;
    }

    public ChunkedWriterMarker getMarker() {
        return this.marker;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int remaining() {
        return this.buffer.length - this.offset;
    }

    public List<byte[]> flush() {
        byte[] bytes = Arrays.copyOfRange(this.buffer, 0, this.offset);
        this.marker.onArray(this.buffer, bytes);
        this.output.add(bytes);
        this.offset = 0;
        return this.output;
    }

    public void reserve(int size) {
        if (this.remaining() < size) {
            int newSize;
            if (this.offset > 0) {
                newSize = this.offset + size;
                if (newSize < 0 || newSize > this.maxChunkSize) {
                    newSize = size;
                    this.flush();
                }
            } else {
                newSize = size;
            }
            if ((newSize = ChunkedWriter.minPowerOfTwo(newSize)) < 0) {
                newSize = Integer.MAX_VALUE;
            }
            newSize = Math.max(newSize, 1024);
            if ((newSize = Math.max(newSize, this.buffer.length)) > this.buffer.length) {
                byte[] newBuffer = new byte[newSize];
                if (this.offset > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.offset);
                }
                this.marker.onArray(this.buffer, newBuffer);
                this.buffer = newBuffer;
            }
        }
    }

    void mark(int position) {
        this.marker.mark(this.buffer, position);
    }

    public void advance(int size) {
        if (this.remaining() < size) {
            throw new IndexOutOfBoundsException("not enough space in the buffer");
        }
        this.offset += size;
    }

    public void write(byte[] src) {
        this.reserve(src.length);
        System.arraycopy(src, 0, this.buffer, this.offset, src.length);
        this.offset += src.length;
    }

    public void write(byte[] src, int offset, int length) {
        ChunkedWriter.checkBounds(offset, length, src.length);
        this.reserve(length);
        System.arraycopy(src, offset, this.buffer, this.offset, length);
        this.offset += length;
    }

    private static int minPowerOfTwo(int n) {
        --n;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return ++n;
    }

    private static void checkBounds(int offset, int length, int size) {
        if ((offset | length | offset + length | size - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

