/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import tech.ytsaurus.client.rows.ConsumerSourceRet;

@FunctionalInterface
public interface ConsumerSource<T>
extends Consumer<T> {
    default public void setRowCount(int rowCount) {
    }

    public static <T> ConsumerSource<T> wrap(Consumer<T> consumer) {
        return consumer::accept;
    }

    public static <T> ConsumerSourceRet<T> list() {
        return ConsumerSource.list(ArrayList::new);
    }

    public static <T> ConsumerSourceRet<T> list(final IntFunction<List<T>> function) {
        return new ConsumerSourceRet<T>(){
            private List<T> list;

            @Override
            public void setRowCount(int rowCount) {
                this.list = (List)function.apply(rowCount);
            }

            @Override
            public void accept(T t) {
                if (this.list == null) {
                    this.list = new ArrayList();
                }
                this.list.add(t);
            }

            @Override
            public List<T> get() {
                return this.list != null ? this.list : Collections.emptyList();
            }
        };
    }
}

