/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import tech.ytsaurus.client.rows.JavaPersistenceApi;
import tech.ytsaurus.core.utils.ClassUtils;

class EntityFieldDescr {
    private final Field field;
    private final boolean isTransient;
    private final boolean isEmbeddable;
    private final List<Type> typeParameters;

    private EntityFieldDescr(Field field) {
        this.field = field;
        this.isTransient = ClassUtils.isFieldTransient((Field)field, JavaPersistenceApi.transientAnnotations());
        this.isEmbeddable = ClassUtils.anyOfAnnotationsPresent(field.getType(), JavaPersistenceApi.embeddableAnnotations());
        this.typeParameters = ClassUtils.getTypeParametersOfField((Field)field);
    }

    Field getField() {
        return this.field;
    }

    boolean isTransient() {
        return this.isTransient;
    }

    boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    static List<EntityFieldDescr> of(List<Field> fields) {
        return fields.stream().map(EntityFieldDescr::new).collect(Collectors.toUnmodifiableList());
    }

    public String toString() {
        return "EntityFieldDescr{field=" + String.valueOf(this.field) + ", isTransient=" + this.isTransient + ", isEmbeddable=" + this.isEmbeddable + ", typeParameters=" + String.valueOf(this.typeParameters) + "}";
    }
}

