/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;
import tech.ytsaurus.client.request.Format;
import tech.ytsaurus.client.rows.EntityFieldDescr;
import tech.ytsaurus.client.rows.EntityTableSchemaCreator;
import tech.ytsaurus.client.rows.JavaPersistenceApi;
import tech.ytsaurus.client.rows.SchemaConverter;
import tech.ytsaurus.client.rows.TiTypeUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.common.Decimal;
import tech.ytsaurus.core.rows.YsonSerializable;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.core.utils.ClassUtils;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;
import tech.ytsaurus.skiff.SkiffParser;
import tech.ytsaurus.skiff.SkiffSchema;
import tech.ytsaurus.skiff.SkiffSerializer;
import tech.ytsaurus.typeinfo.DecimalType;
import tech.ytsaurus.typeinfo.StructType;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.yson.BufferReference;
import tech.ytsaurus.yson.ClosableYsonConsumer;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;

@NonNullApi
@NonNullFields
public class EntitySkiffSerializer<T> {
    private static final byte ZERO_TAG = 0;
    private static final byte ONE_TAG = 1;
    private static final byte END_TAG = -1;
    private final Class<T> entityClass;
    private final Map<Class<?>, List<EntityFieldDescr>> entityFieldsMap = new HashMap();
    private final Map<Class<?>, Constructor<?>> objectConstructorMap = new HashMap();
    @Nullable
    private TableSchema entityTableSchema;
    @Nullable
    private TiType entityTiType;
    @Nullable
    private SkiffSchema skiffSchema;
    @Nullable
    private Format format;

    public EntitySkiffSerializer(Class<T> entityClass) {
        if (!ClassUtils.anyOfAnnotationsPresent(entityClass, JavaPersistenceApi.entityAnnotations())) {
            throw new IllegalArgumentException("Class must be annotated with @Entity");
        }
        this.entityClass = entityClass;
        try {
            this.entityTableSchema = EntityTableSchemaCreator.create(entityClass);
            this.entityTiType = TiTypeUtil.tableSchemaToStructTiType(this.entityTableSchema);
            this.skiffSchema = SchemaConverter.toSkiffSchema(this.entityTableSchema);
            this.format = Format.skiff(this.skiffSchema, 1);
        }
        catch (EntityTableSchemaCreator.PrecisionAndScaleNotSpecifiedException precisionAndScaleNotSpecifiedException) {
            // empty catch block
        }
        this.entityFieldsMap.put(entityClass, EntitySkiffSerializer.getEntityFieldDescrs(entityClass));
    }

    public Optional<Format> getFormat() {
        return Optional.ofNullable(this.format);
    }

    public Optional<TableSchema> getEntityTableSchema() {
        return Optional.ofNullable(this.entityTableSchema);
    }

    public void setTableSchema(TableSchema tableSchema) {
        this.entityTableSchema = EntityTableSchemaCreator.create(this.entityClass, tableSchema);
        this.entityTiType = TiTypeUtil.tableSchemaToStructTiType(this.entityTableSchema);
        this.skiffSchema = SchemaConverter.toSkiffSchema(this.entityTableSchema);
        this.format = Format.skiff(this.skiffSchema, 1);
    }

    public byte[] serialize(T object) {
        if (this.entityTiType == null) {
            this.throwNoSchemaException();
        }
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
        this.serialize(object, new SkiffSerializer((OutputStream)byteOS));
        try {
            byteOS.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteOS.toByteArray();
    }

    public void serialize(T object, SkiffSerializer serializer) {
        if (this.entityTiType == null) {
            this.throwNoSchemaException();
        }
        this.serializeEntity(object, this.entityTiType, serializer);
    }

    public Optional<T> deserialize(byte[] objectBytes) {
        return this.deserialize(new SkiffParser((InputStream)new ByteArrayInputStream(objectBytes)));
    }

    public Optional<T> deserialize(SkiffParser parser) {
        if (this.entityTiType == null) {
            this.throwNoSchemaException();
        }
        return Optional.ofNullable(this.deserializeObject(this.entityClass, this.entityTiType, List.of(), parser));
    }

    private <ObjectType> void serializeObject(@Nullable ObjectType object, TiType tiType, SkiffSerializer serializer) {
        boolean isNullable = tiType.isOptional();
        if (object == null) {
            if (!isNullable) {
                throw new NullPointerException(String.format("Field '%s' is non nullable", tiType));
            }
            serializer.serializeByte((byte)0);
            return;
        }
        if (isNullable) {
            serializer.serializeByte((byte)1);
            tiType = tiType.asOptional().getItem();
        }
        if (TiTypeUtil.isSimpleType(tiType)) {
            this.serializeSimpleType(object, tiType, serializer);
            return;
        }
        if (tiType.isDecimal()) {
            if (!object.getClass().equals(BigDecimal.class)) {
                this.throwInvalidSchemeException(null);
            }
            this.serializeDecimal((BigDecimal)object, tiType.asDecimal(), serializer);
            return;
        }
        this.serializeComplexObject(object, tiType, serializer);
    }

    private void serializeDecimal(BigDecimal value, DecimalType decimalType, SkiffSerializer serializer) {
        byte[] dataInBigEndian = Decimal.textToBinary((String)value.toPlainString(), (int)decimalType.getPrecision(), (int)decimalType.getScale());
        dataInBigEndian[0] = (byte)(dataInBigEndian[0] ^ 0x80);
        for (int i = dataInBigEndian.length - 1; i >= 0; --i) {
            serializer.serializeByte(dataInBigEndian[i]);
        }
    }

    private <SimpleType> void serializeSimpleType(SimpleType object, TiType tiType, SkiffSerializer serializer) {
        try {
            if (tiType.isInt8()) {
                serializer.serializeByte(((Byte)object).byteValue());
            } else if (tiType.isInt16()) {
                this.serializeInt16(object, serializer);
            } else if (tiType.isInt32()) {
                this.serializeInt32(object, serializer);
            } else if (tiType.isInt64()) {
                this.serializeInt64(object, serializer);
            } else if (tiType.isUint8()) {
                serializer.serializeUint8(((Long)object).longValue());
            } else if (tiType.isUint16()) {
                serializer.serializeUint16(((Long)object).longValue());
            } else if (tiType.isUint32()) {
                serializer.serializeUint32(((Long)object).longValue());
            } else if (tiType.isUint64()) {
                serializer.serializeUint64(((Long)object).longValue());
            } else if (tiType.isDouble()) {
                serializer.serializeDouble(((Double)object).doubleValue());
            } else if (tiType.isBool()) {
                serializer.serializeBoolean(((Boolean)object).booleanValue());
            } else if (tiType.isUtf8()) {
                this.serializeUtf8(object, serializer);
            } else if (tiType.isString()) {
                this.serializeString(object, serializer);
            } else if (tiType.isUuid()) {
                serializer.serializeGuid((GUID)object);
            } else if (tiType.isTimestamp()) {
                serializer.serializeTimestamp((Instant)object);
            } else if (tiType.isYson()) {
                this.serializeYson(object, serializer);
            } else {
                throw new IllegalArgumentException(String.format("Type '%s' is not supported", tiType));
            }
            return;
        }
        catch (ClassCastException e) {
            this.throwInvalidSchemeException(e);
            throw new IllegalStateException();
        }
    }

    private <Int16Type> void serializeInt16(Int16Type object, SkiffSerializer serializer) {
        if (ClassUtils.isAssignableToShort(object.getClass())) {
            serializer.serializeShort(((Number)object).shortValue());
            return;
        }
        this.throwIncorrectFieldTypeException("int16", object.getClass());
    }

    private <Int32Type> void serializeInt32(Int32Type object, SkiffSerializer serializer) {
        if (ClassUtils.isAssignableToInt(object.getClass())) {
            serializer.serializeInt(((Number)object).intValue());
            return;
        }
        this.throwIncorrectFieldTypeException("int32", object.getClass());
    }

    private <Int64Type> void serializeInt64(Int64Type object, SkiffSerializer serializer) {
        long l = 0L;
        if (ClassUtils.isAssignableToLong(object.getClass())) {
            l = ((Number)object).longValue();
        } else if (object.getClass().equals(Instant.class)) {
            l = ((Instant)object).toEpochMilli();
        } else {
            this.throwIncorrectFieldTypeException("int64", object.getClass());
        }
        serializer.serializeLong(l);
    }

    private <Utf8Type> void serializeUtf8(Utf8Type object, SkiffSerializer serializer) {
        String str = null;
        if (object.getClass().equals(String.class)) {
            str = (String)object;
        } else if (Enum.class.isAssignableFrom(object.getClass())) {
            str = ((Enum)object).name();
        } else {
            this.throwIncorrectFieldTypeException("utf8", object.getClass());
        }
        serializer.serializeUtf8(str);
    }

    private <StringType> void serializeString(StringType object, SkiffSerializer serializer) {
        if (object.getClass().equals(byte[].class)) {
            serializer.serializeString((byte[])object);
        } else if (object.getClass().equals(String.class) || Enum.class.isAssignableFrom(object.getClass())) {
            this.serializeUtf8(object, serializer);
        } else {
            this.throwIncorrectFieldTypeException("string", object.getClass());
        }
    }

    private <YsonType> void serializeYson(YsonType object, SkiffSerializer serializer) {
        ByteArrayOutputStream byteOutputStreamForYson = new ByteArrayOutputStream();
        ClosableYsonConsumer consumer = YTreeBinarySerializer.getSerializer((OutputStream)byteOutputStreamForYson);
        if (YTreeNode.class.isAssignableFrom(object.getClass())) {
            YTreeNodeUtils.walk((YTreeNode)((YTreeNode)object), (YsonConsumer)consumer, (boolean)true);
        } else if (YsonSerializable.class.isAssignableFrom(object.getClass())) {
            ((YsonSerializable)object).serialize((YsonConsumer)consumer);
        } else {
            this.throwIncorrectFieldTypeException("yson", object.getClass());
        }
        consumer.close();
        byte[] bytes = byteOutputStreamForYson.toByteArray();
        serializer.serializeString(bytes);
    }

    private <ObjectType> void serializeComplexObject(ObjectType object, TiType objectTiType, SkiffSerializer serializer) {
        Class<?> clazz = object.getClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            this.serializeCollection(object, objectTiType, serializer);
            return;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            this.serializeMap(object, objectTiType, serializer);
            return;
        }
        if (clazz.isArray()) {
            this.serializeArray(object, objectTiType, serializer);
            return;
        }
        this.serializeEntity(object, objectTiType, serializer);
    }

    private static List<EntityFieldDescr> getEntityFieldDescrs(Class<?> entityClass) {
        List declaredFields = ClassUtils.getAllDeclaredFields(entityClass);
        ClassUtils.setFieldsAccessibleToTrue((List)declaredFields);
        return EntityFieldDescr.of(declaredFields);
    }

    private <ObjectType> void serializeEntity(ObjectType object, TiType structTiType, SkiffSerializer serializer) {
        if (!structTiType.isStruct()) {
            this.throwInvalidSchemeException(null);
        }
        this.serializeEntity(object, structTiType.asStruct().getMembers().iterator(), serializer);
    }

    private <ObjectType> void serializeEntity(ObjectType object, Iterator<StructType.Member> structMembersIterator, SkiffSerializer serializer) {
        if (!structMembersIterator.hasNext()) {
            this.throwInvalidSchemeException(null);
        }
        List fieldDescriptions = this.entityFieldsMap.computeIfAbsent(object.getClass(), EntitySkiffSerializer::getEntityFieldDescrs);
        for (EntityFieldDescr fieldDescr : fieldDescriptions) {
            if (fieldDescr.isTransient()) continue;
            try {
                if (fieldDescr.isEmbeddable()) {
                    this.serializeEntity(fieldDescr.getField().get(object), structMembersIterator, serializer);
                    continue;
                }
                this.serializeObject(fieldDescr.getField().get(object), structMembersIterator.next().getType(), serializer);
            }
            catch (IllegalAccessException e) {
                this.throwInvalidSchemeException(e);
            }
        }
    }

    private <CollectionType, ElemType> void serializeCollection(CollectionType object, TiType tiType, SkiffSerializer serializer) {
        if (!tiType.isList()) {
            this.throwInvalidSchemeException(null);
        }
        Collection collection = (Collection)ClassUtils.castToType(object);
        TiType elemTiType = tiType.asList().getItem();
        for (Object elem : collection) {
            serializer.serializeByte((byte)0);
            this.serializeObject(elem, elemTiType, serializer);
        }
        serializer.serializeByte((byte)-1);
    }

    private <MapType, KeyType, ValueType> void serializeMap(MapType object, TiType tiType, SkiffSerializer serializer) {
        if (!tiType.isDict()) {
            this.throwInvalidSchemeException(null);
        }
        Map map = (Map)ClassUtils.castToType(object);
        TiType keyTiType = tiType.asDict().getKey();
        TiType valueTiType = tiType.asDict().getValue();
        for (Map.Entry entry : map.entrySet()) {
            serializer.serializeByte((byte)0);
            this.serializeObject(entry.getKey(), keyTiType, serializer);
            this.serializeObject(entry.getValue(), valueTiType, serializer);
        }
        serializer.serializeByte((byte)-1);
    }

    private <ArrayType, ElemType> void serializeArray(ArrayType object, TiType tiType, SkiffSerializer serializer) {
        Class<?> elementClass;
        if (!tiType.isList()) {
            this.throwInvalidSchemeException(null);
        }
        Object[] list = (elementClass = object.getClass().getComponentType()).isPrimitive() ? ClassUtils.boxArray(object, elementClass) : (Object[])ClassUtils.castToType(object);
        TiType elemTiType = tiType.asList().getItem();
        for (Object elem : list) {
            serializer.serializeByte((byte)0);
            this.serializeObject(elem, elemTiType, serializer);
        }
        serializer.serializeByte((byte)-1);
    }

    @Nullable
    private <ObjectType> ObjectType deserializeObject(Class<ObjectType> clazz, TiType tiType, List<Type> genericTypeParameters, SkiffParser parser) {
        if (tiType.isOptional()) {
            if (parser.parseVariant8Tag() == 0) {
                return null;
            }
            tiType = tiType.asOptional().getItem();
        }
        if (TiTypeUtil.isSimpleType(tiType)) {
            return this.deserializeSimpleType(clazz, tiType, parser);
        }
        if (tiType.isDecimal()) {
            if (!clazz.equals(BigDecimal.class)) {
                this.throwInvalidSchemeException(null);
            }
            return (ObjectType)ClassUtils.castToType((Object)this.deserializeDecimal(tiType.asDecimal(), parser));
        }
        return this.deserializeComplexObject(clazz, tiType, genericTypeParameters, parser);
    }

    private BigDecimal deserializeDecimal(DecimalType decimalType, SkiffParser parser) {
        byte[] binaryDecimal = parser.getDataInBigEndian(this.getBinaryDecimalLength((TiType)decimalType));
        binaryDecimal[0] = (byte)(binaryDecimal[0] ^ 0x80);
        String textDecimal = Decimal.binaryToText((byte[])binaryDecimal, (int)decimalType.getPrecision(), (int)decimalType.getScale());
        if (textDecimal.equals("nan") || textDecimal.equals("inf") || textDecimal.equals("-inf")) {
            throw new IllegalArgumentException(String.format("YT Decimal value '%s' is not supported by Java BigDecimal", textDecimal));
        }
        return new BigDecimal(textDecimal);
    }

    private int getBinaryDecimalLength(TiType tiType) {
        int precision = tiType.asDecimal().getPrecision();
        if (precision <= 9) {
            return 4;
        }
        if (precision <= 18) {
            return 8;
        }
        return 16;
    }

    private <ObjectType> ObjectType deserializeComplexObject(Class<ObjectType> clazz, TiType tiType, List<Type> genericTypeParameters, SkiffParser parser) {
        if (List.class.isAssignableFrom(clazz)) {
            return (ObjectType)ClassUtils.castToType(this.deserializeCollection(clazz, genericTypeParameters.get(0), tiType, ArrayList.class, parser));
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return (ObjectType)ClassUtils.castToType(this.deserializeCollection(clazz, genericTypeParameters.get(0), tiType, HashSet.class, parser));
        }
        if (Queue.class.isAssignableFrom(clazz)) {
            return (ObjectType)ClassUtils.castToType(this.deserializeCollection(clazz, genericTypeParameters.get(0), tiType, LinkedList.class, parser));
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return (ObjectType)ClassUtils.castToType(this.deserializeMap(clazz, genericTypeParameters.get(0), genericTypeParameters.get(1), tiType, parser));
        }
        if (clazz.isArray()) {
            return (ObjectType)this.deserializeArray(clazz, tiType, parser);
        }
        return this.deserializeEntity(clazz, tiType, parser);
    }

    private <ObjectType> ObjectType deserializeEntity(Class<ObjectType> clazz, TiType tiType, SkiffParser parser) {
        if (!tiType.isStruct()) {
            this.throwInvalidSchemeException(null);
        }
        return this.deserializeEntity(clazz, tiType.asStruct().getMembers().iterator(), parser);
    }

    private <ObjectType> ObjectType deserializeEntity(Class<ObjectType> clazz, Iterator<StructType.Member> structMembersIterator, SkiffParser parser) {
        if (!structMembersIterator.hasNext()) {
            this.throwInvalidSchemeException(null);
        }
        Constructor defaultConstructor = this.objectConstructorMap.computeIfAbsent(clazz, ClassUtils::getEmptyConstructor);
        Object object = ClassUtils.getInstanceWithoutArguments((Constructor)defaultConstructor);
        List fieldDescriptions = this.entityFieldsMap.computeIfAbsent(clazz, EntitySkiffSerializer::getEntityFieldDescrs);
        for (EntityFieldDescr fieldDescr : fieldDescriptions) {
            if (fieldDescr.isTransient()) continue;
            try {
                Object value = fieldDescr.isEmbeddable() ? this.deserializeEntity(fieldDescr.getField().getType(), structMembersIterator, parser) : this.deserializeObject((Class)ClassUtils.castToType(fieldDescr.getField().getType()), structMembersIterator.next().getType(), fieldDescr.getTypeParameters(), parser);
                fieldDescr.getField().set(object, value);
            }
            catch (IllegalAccessException e) {
                this.throwInvalidSchemeException(e);
            }
        }
        return (ObjectType)object;
    }

    private <ElemType> Collection<ElemType> deserializeCollection(Class<?> clazz, Type elementType, TiType tiType, Class<?> defaultClass, SkiffParser parser) {
        if (!tiType.isList()) {
            this.throwInvalidSchemeException(null);
        }
        Constructor<?> collectionConstructor = this.objectConstructorMap.computeIfAbsent(clazz, ClassUtils.getConstructorOrDefaultFor(defaultClass));
        Collection collection = (Collection)ClassUtils.getInstanceWithoutArguments(collectionConstructor);
        ClassUtils.TypeDescr elementTypeDescr = ClassUtils.getTypeDescription((Type)elementType);
        while (parser.parseInt8() != -1) {
            collection.add(ClassUtils.castToType(this.deserializeObject(elementTypeDescr.getTypeClass(), tiType.asList().getItem(), elementTypeDescr.getTypeParameters(), parser)));
        }
        return collection;
    }

    private <KeyType, ValueType> Map<KeyType, ValueType> deserializeMap(Class<?> clazz, Type keyType, Type valueType, TiType tiType, SkiffParser parser) {
        if (!tiType.isDict()) {
            this.throwInvalidSchemeException(null);
        }
        Constructor<?> mapConstructor = this.objectConstructorMap.computeIfAbsent(clazz, ClassUtils.getConstructorOrDefaultFor(HashMap.class));
        Map map = (Map)ClassUtils.getInstanceWithoutArguments(mapConstructor);
        ClassUtils.TypeDescr keyTypeDescr = ClassUtils.getTypeDescription((Type)keyType);
        ClassUtils.TypeDescr valueTypeDescr = ClassUtils.getTypeDescription((Type)valueType);
        while (parser.parseInt8() != -1) {
            map.put(ClassUtils.castToType(this.deserializeObject(keyTypeDescr.getTypeClass(), tiType.asDict().getKey(), keyTypeDescr.getTypeParameters(), parser)), ClassUtils.castToType(this.deserializeObject(valueTypeDescr.getTypeClass(), tiType.asDict().getValue(), valueTypeDescr.getTypeParameters(), parser)));
        }
        return map;
    }

    private <ArrayType, ElemType> ArrayType deserializeArray(Class<?> clazz, TiType tiType, SkiffParser parser) {
        Class<?> elementClass = clazz.getComponentType();
        List list = (List)ClassUtils.castToType(this.deserializeCollection(clazz, elementClass, tiType, ArrayList.class, parser));
        Object arrayObject = Array.newInstance(elementClass, list.size());
        Object[] array = elementClass.isPrimitive() ? ClassUtils.boxArray((Object)arrayObject, elementClass) : (Object[])ClassUtils.castToType((Object)arrayObject);
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        if (elementClass.isPrimitive()) {
            return (ArrayType)ClassUtils.unboxArray((Object)array, array.getClass().getComponentType());
        }
        return (ArrayType)ClassUtils.castToType((Object)array);
    }

    private <SimpleType> SimpleType deserializeSimpleType(Class<SimpleType> clazz, TiType tiType, SkiffParser parser) {
        try {
            if (tiType.isInt8()) {
                return (SimpleType)ClassUtils.castToType((Object)parser.parseInt8());
            }
            if (tiType.isInt16()) {
                return this.deserializeInt16(clazz, parser);
            }
            if (tiType.isInt32()) {
                return this.deserializeInt32(clazz, parser);
            }
            if (tiType.isInt64()) {
                return this.deserializeInt64(clazz, parser);
            }
            if (tiType.isUint8()) {
                return (SimpleType)ClassUtils.castToType((Object)parser.parseUint8());
            }
            if (tiType.isUint16()) {
                return (SimpleType)ClassUtils.castToType((Object)parser.parseUint16());
            }
            if (tiType.isUint32()) {
                return (SimpleType)ClassUtils.castToType((Object)parser.parseUint32());
            }
            if (tiType.isUint64()) {
                return (SimpleType)ClassUtils.castToType((Object)parser.parseUint64());
            }
            if (tiType.isDouble()) {
                return (SimpleType)ClassUtils.castToType((Object)parser.parseDouble());
            }
            if (tiType.isBool()) {
                return (SimpleType)ClassUtils.castToType((Object)parser.parseBoolean());
            }
            if (tiType.isUtf8()) {
                return (SimpleType)ClassUtils.castToType(this.deserializeUtf8(clazz, parser));
            }
            if (tiType.isString()) {
                return this.deserializeString(clazz, parser);
            }
            if (tiType.isUuid()) {
                return (SimpleType)ClassUtils.castToType((Object)this.deserializeGuid(parser));
            }
            if (tiType.isTimestamp()) {
                return (SimpleType)ClassUtils.castToType((Object)this.deserializeTimestamp(parser));
            }
            if (tiType.isYson()) {
                return (SimpleType)ClassUtils.castToType(this.deserializeYson(clazz, parser));
            }
            throw new IllegalArgumentException(String.format("Type '%s' is not supported", tiType));
        }
        catch (ClassCastException e) {
            this.throwInvalidSchemeException(e);
            throw new IllegalStateException();
        }
    }

    private <Int16Type> Int16Type deserializeInt16(Class<Int16Type> clazz, SkiffParser parser) {
        short int16 = parser.parseInt16();
        if (ClassUtils.isAssignableToShort(clazz)) {
            return (Int16Type)ClassUtils.castShortToActualType((short)int16, clazz);
        }
        this.throwIncorrectFieldTypeException("int16", clazz);
        return null;
    }

    private <Int32Type> Int32Type deserializeInt32(Class<Int32Type> clazz, SkiffParser parser) {
        int int32 = parser.parseInt32();
        if (ClassUtils.isAssignableToInt(clazz)) {
            return (Int32Type)ClassUtils.castIntToActualType((int)int32, clazz);
        }
        this.throwIncorrectFieldTypeException("int32", clazz);
        return null;
    }

    private <Int64Type> Int64Type deserializeInt64(Class<Int64Type> clazz, SkiffParser parser) {
        long int64 = parser.parseInt64();
        if (ClassUtils.isAssignableToLong(clazz)) {
            return (Int64Type)ClassUtils.castLongToActualType((long)int64, clazz);
        }
        if (clazz.equals(Instant.class)) {
            return (Int64Type)ClassUtils.castToType((Object)Instant.ofEpochMilli(int64));
        }
        this.throwIncorrectFieldTypeException("int64", clazz);
        return null;
    }

    private <Utf8Type> Utf8Type deserializeUtf8(Class<Utf8Type> clazz, SkiffParser parser) {
        BufferReference ref = parser.parseString32();
        String str = new String(ref.getBuffer(), ref.getOffset(), ref.getLength(), StandardCharsets.UTF_8);
        if (clazz.equals(String.class)) {
            return (Utf8Type)ClassUtils.castToType((Object)str);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return (Utf8Type)ClassUtils.castToType(this.deserializeEnum(clazz, str));
        }
        this.throwIncorrectFieldTypeException("utf8", clazz);
        return null;
    }

    private <E extends Enum<E>> E deserializeEnum(Class<?> clazz, String value) {
        return (E)Enum.valueOf((Class)ClassUtils.castToType(clazz), value);
    }

    private <StringType> StringType deserializeString(Class<StringType> clazz, SkiffParser parser) {
        if (clazz.equals(byte[].class)) {
            BufferReference ref = parser.parseString32();
            return (StringType)ClassUtils.castToType((Object)Arrays.copyOfRange(ref.getBuffer(), ref.getOffset(), ref.getOffset() + ref.getLength()));
        }
        if (clazz.equals(String.class) || Enum.class.isAssignableFrom(clazz)) {
            return this.deserializeUtf8(clazz, parser);
        }
        this.throwIncorrectFieldTypeException("string", clazz);
        return null;
    }

    private GUID deserializeGuid(SkiffParser parser) {
        if (parser.parseInt32() != 16) {
            throw new IllegalArgumentException("Length of UUID must be exactly 16 bytes");
        }
        return new GUID(parser.parseInt64(), parser.parseInt64());
    }

    private Instant deserializeTimestamp(SkiffParser parser) {
        return Instant.ofEpochMilli(parser.parseUint64());
    }

    private <YsonType> YsonType deserializeYson(Class<YsonType> clazz, SkiffParser parser) {
        BufferReference ref = parser.parseYson32();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(ref.getBuffer(), ref.getOffset(), ref.getLength());
        YTreeNode node = YTreeBinarySerializer.deserialize((InputStream)inputStream);
        if (YTreeNode.class.isAssignableFrom(clazz)) {
            return (YsonType)ClassUtils.castToType((Object)node);
        }
        if (YsonSerializable.class.isAssignableFrom(clazz)) {
            Constructor constructor = this.objectConstructorMap.computeIfAbsent(clazz, ClassUtils::getEmptyConstructor);
            YsonSerializable ysonSerializable = (YsonSerializable)ClassUtils.getInstanceWithoutArguments((Constructor)constructor);
            ysonSerializable.deserialize(node);
            return (YsonType)ClassUtils.castToType((Object)ysonSerializable);
        }
        this.throwIncorrectFieldTypeException("yson", clazz);
        return null;
    }

    private void throwInvalidSchemeException(@Nullable Exception e) {
        throw new IllegalStateException("Scheme does not correspond to object", e);
    }

    private void throwIncorrectFieldTypeException(String typeName, Class<?> clazz) {
        throw new RuntimeException(String.format("Incorrect field type for '%s': %s", typeName, clazz.getCanonicalName()));
    }

    private void throwNoSchemaException() {
        throw new IllegalStateException("Cannot create or get table schema");
    }
}

