/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import tech.ytsaurus.client.rows.VersionedRow;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.ysontree.YTreeMapNode;

public class VersionedRowset {
    private final TableSchema schema;
    private final List<VersionedRow> rows;

    public VersionedRowset(TableSchema schema, List<VersionedRow> rows) {
        this.schema = Objects.requireNonNull(schema);
        this.rows = Objects.requireNonNull(rows);
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public List<VersionedRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public List<YTreeMapNode> getYTreeRows() {
        return new AbstractList<YTreeMapNode>(){

            @Override
            public YTreeMapNode get(int index) {
                VersionedRow row = VersionedRowset.this.rows.get(index);
                return row != null ? row.toYTreeMap(VersionedRowset.this.schema) : null;
            }

            @Override
            public int size() {
                return VersionedRowset.this.rows.size();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionedRowset)) {
            return false;
        }
        VersionedRowset that = (VersionedRowset)o;
        if (!this.schema.equals((Object)that.schema)) {
            return false;
        }
        return this.rows.equals(that.rows);
    }

    public int hashCode() {
        int result = this.schema.hashCode();
        result = 31 * result + this.rows.hashCode();
        return result;
    }

    public String toString() {
        return "VersionedRowset{schema=" + String.valueOf(this.schema) + ", rows=" + String.valueOf(this.rows) + "}";
    }
}

