/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import tech.ytsaurus.skiff.WireType;
import tech.ytsaurus.typeinfo.TiType;

class WireTypeUtil {
    private WireTypeUtil() {
    }

    static WireType getWireTypeOf(TiType tiType) {
        if (tiType.isInt8()) {
            return WireType.INT_8;
        }
        if (tiType.isInt16()) {
            return WireType.INT_16;
        }
        if (tiType.isInt32()) {
            return WireType.INT_32;
        }
        if (tiType.isInt64()) {
            return WireType.INT_64;
        }
        if (tiType.isUint8()) {
            return WireType.UINT_8;
        }
        if (tiType.isUint16()) {
            return WireType.UINT_16;
        }
        if (tiType.isUint32()) {
            return WireType.UINT_32;
        }
        if (tiType.isUint64()) {
            return WireType.UINT_64;
        }
        if (tiType.isDouble()) {
            return WireType.DOUBLE;
        }
        if (tiType.isBool()) {
            return WireType.BOOLEAN;
        }
        if (tiType.isUtf8()) {
            return WireType.STRING_32;
        }
        if (tiType.isString()) {
            return WireType.STRING_32;
        }
        if (tiType.isUuid()) {
            return WireType.STRING_32;
        }
        if (tiType.isYson()) {
            return WireType.YSON_32;
        }
        if (tiType.isTimestamp()) {
            return WireType.UINT_64;
        }
        if (tiType.isDecimal()) {
            int precision = tiType.asDecimal().getPrecision();
            if (precision <= 9) {
                return WireType.INT_32;
            }
            if (precision <= 18) {
                return WireType.INT_64;
            }
            return WireType.INT_128;
        }
        return WireType.TUPLE;
    }
}

