/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rows.ConsumerSource;
import tech.ytsaurus.client.rows.WireRowsetDeserializer;
import tech.ytsaurus.client.rows.WireValueDeserializer;
import tech.ytsaurus.core.rows.YTreeSerializer;
import tech.ytsaurus.core.tables.ColumnSchema;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;

public class YTreeDeserializer<T>
implements WireRowsetDeserializer<T>,
WireValueDeserializer<Void> {
    private TableSchema schema;
    private String[] id2key;
    private YTreeBuilder builder = YTree.builder();
    private final YTreeSerializer<T> serializer;
    private final ConsumerSource<T> consumer;

    public YTreeDeserializer(YTreeSerializer<T> serializer) {
        this(serializer, unused -> {});
    }

    public YTreeDeserializer(YTreeSerializer<T> serializer, @Nullable ConsumerSource<T> consumer) {
        this.serializer = Objects.requireNonNull(serializer);
        this.consumer = Objects.requireNonNull(consumer);
    }

    @Override
    public void updateSchema(@Nonnull TableSchema schema) {
        if (this.schema == null || !this.schema.equals((Object)schema)) {
            int index = 0;
            this.id2key = new String[schema.getColumns().size()];
            for (ColumnSchema column : schema.getColumns()) {
                this.id2key[index++] = column.getName();
            }
            this.schema = schema;
        }
    }

    @Override
    public void setRowCount(int rowCount) {
        this.consumer.setRowCount(rowCount);
    }

    @Override
    @Nonnull
    public WireValueDeserializer<?> onNewRow(int columnCount) {
        this.builder = YTree.builder().beginMap();
        return this;
    }

    @Override
    @Nonnull
    public T onCompleteRow() {
        Object row = this.serializer.deserialize((YTreeNode)this.builder.endMap().build().mapNode());
        this.consumer.accept(row);
        return (T)row;
    }

    @Override
    @Nullable
    public T onNullRow() {
        this.consumer.accept(null);
        return null;
    }

    @Override
    public void setId(int id) {
        if (id >= this.id2key.length) {
            throw new IllegalStateException();
        }
        this.builder.key(this.id2key[id]);
    }

    @Override
    public void setType(ColumnValueType type) {
    }

    @Override
    public void setAggregate(boolean aggregate) {
    }

    @Override
    public void setTimestamp(long timestamp) {
    }

    @Override
    public Void build() {
        return null;
    }

    @Override
    public void onEntity() {
        this.builder.entity();
    }

    @Override
    public void onInteger(long value) {
        this.builder.value(value);
    }

    @Override
    public void onBoolean(boolean value) {
        this.builder.value(value);
    }

    @Override
    public void onDouble(double value) {
        this.builder.value(value);
    }

    @Override
    public void onBytes(byte[] bytes) {
        this.builder.value(bytes);
    }
}

