/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rows;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rows.WireProtocolWriteable;
import tech.ytsaurus.client.rows.WireRowSerializer;
import tech.ytsaurus.core.rows.YTreeRowSerializer;
import tech.ytsaurus.core.rows.YTreeSerializer;
import tech.ytsaurus.core.tables.ColumnSchema;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.rpcproxy.TRowsetDescriptor;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.yson.ClosableYsonConsumer;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;

public class YTreeWireRowSerializer<T>
implements WireRowSerializer<T> {
    private static final int BUFFER_SIZE = 64;
    private static final int OUTPUT_SIZE = 256;
    protected final YTreeRowSerializer<T> objectSerializer;
    protected TableSchema tableSchema;
    protected YTreeConsumerProxy delegate;

    protected YTreeWireRowSerializer(YTreeRowSerializer<T> objectSerializer) {
        this.objectSerializer = Objects.requireNonNull(objectSerializer);
        this.tableSchema = TableSchema.builder().build();
        this.delegate = new YTreeConsumerProxy(this.tableSchema);
    }

    public static <T> YTreeWireRowSerializer<T> forClass(YTreeSerializer<T> serializer) {
        if (serializer instanceof YTreeRowSerializer) {
            return new YTreeWireRowSerializer<T>((YTreeRowSerializer)serializer);
        }
        throw new RuntimeException("Expected YTreeRowSerializer in YTreeWireRowSerializer.forClass()");
    }

    @Override
    public TableSchema getSchema() {
        return this.tableSchema;
    }

    @Override
    public void serializeRow(T row, WireProtocolWriteable writeable, boolean keyFieldsOnly, boolean aggregate, int[] idMapping) {
        this.objectSerializer.serializeRow(row, this.delegate.wrap(writeable, aggregate), keyFieldsOnly, null);
        this.delegate.complete();
    }

    @Override
    public void updateSchema(TRowsetDescriptor schemaDelta) {
        TableSchema.Builder builder = this.tableSchema.toBuilder();
        for (TRowsetDescriptor.TNameTableEntry entry : schemaDelta.getNameTableEntriesList()) {
            if (this.tableSchema.findColumn(entry.getName()) != -1) continue;
            builder.add(new ColumnSchema(entry.getName(), ColumnValueType.fromValue((int)entry.getType())));
        }
        this.tableSchema = builder.build();
        this.delegate.updateSchema(schemaDelta);
    }

    static TiType asType(YTreeSerializer<?> serializer) {
        TiType type = serializer.getColumnValueType();
        if (type.isNullable()) {
            return type;
        }
        return TiType.optional((TiType)type);
    }

    static class ColumnWithIndex {
        private final int columnId;
        private final ColumnValueType columnType;
        @Nullable
        private final String aggregate;

        ColumnWithIndex(int columnId, ColumnValueType columnType, @Nullable String aggregate) {
            this.columnId = columnId;
            this.columnType = columnType;
            this.aggregate = aggregate;
        }
    }

    private static class YTreeConsumerDirect
    implements YsonConsumer {
        private final Map<String, ColumnWithIndex> schema;
        private WireProtocolWriteable writeable;
        private ColumnWithIndex currentColumn;
        private int columnCount;
        private boolean aggregate = false;

        private YTreeConsumerDirect(TableSchema tableSchema) {
            this.schema = new HashMap<String, ColumnWithIndex>(tableSchema.getColumnsCount());
            for (int i = 0; i < tableSchema.getColumnsCount(); ++i) {
                ColumnSchema columnSchema = tableSchema.getColumnSchema(i);
                if (columnSchema == null) continue;
                this.schema.put(columnSchema.getName(), new ColumnWithIndex(i, columnSchema.getWireType(), columnSchema.getAggregate()));
            }
        }

        void updateSchema(TRowsetDescriptor schemaDelta) {
            for (TRowsetDescriptor.TNameTableEntry entry : schemaDelta.getNameTableEntriesList()) {
                if (this.schema.containsKey(entry.getName())) continue;
                int index = this.schema.size();
                this.schema.put(entry.getName(), new ColumnWithIndex(index, ColumnValueType.fromValue((int)entry.getType()), null));
            }
        }

        void complete() {
            this.writeable.overwriteValueCount(this.columnCount);
        }

        void wrap(WireProtocolWriteable writeable, boolean aggregate) {
            this.writeable = writeable;
            this.columnCount = 0;
            this.aggregate = aggregate;
            writeable.writeValueCount(0);
        }

        public void onUnsignedInteger(long value) {
            if (this.currentColumn != null) {
                this.onInteger(value);
            }
        }

        public void onString(@Nonnull String value) {
            if (this.currentColumn != null) {
                this.onBytesDirect(value.getBytes(StandardCharsets.UTF_8));
            }
        }

        public void onListItem() {
            throw new IllegalStateException("Unsupported operation");
        }

        public void onBeginList() {
            throw new IllegalStateException("Unsupported operation");
        }

        public void onEndList() {
            throw new IllegalStateException("Unsupported operation");
        }

        public void onBeginAttributes() {
            throw new IllegalStateException("Unsupported operation");
        }

        public void onEndAttributes() {
            throw new IllegalStateException("Unsupported operation");
        }

        public void onBeginMap() {
            throw new IllegalStateException("Unsupported operation");
        }

        public void onEndMap() {
            throw new IllegalStateException("Unsupported operation");
        }

        public void onKeyedItem(@Nonnull byte[] value, int offset, int length) {
            this.onKeyedItem(new String(value, offset, length, StandardCharsets.UTF_8));
        }

        public void onKeyedItem(@Nonnull String key) {
            this.currentColumn = this.schema.get(key);
            if (this.schema.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.currentColumn != null) {
                ++this.columnCount;
            }
        }

        public void onEntity() {
            if (this.currentColumn != null) {
                this.writeable.writeValueHeader(this.currentColumn.columnId, ColumnValueType.NULL, this.aggregate && this.currentColumn.aggregate != null, 0);
            }
        }

        public void onInteger(long value) {
            if (this.currentColumn != null) {
                this.writeable.writeValueHeader(this.currentColumn.columnId, this.currentColumn.columnType, this.aggregate && this.currentColumn.aggregate != null, 0);
                this.writeable.onInteger(value);
            }
        }

        public void onBoolean(boolean value) {
            if (this.currentColumn != null) {
                this.writeable.writeValueHeader(this.currentColumn.columnId, this.currentColumn.columnType, this.aggregate && this.currentColumn.aggregate != null, 0);
                this.writeable.onBoolean(value);
            }
        }

        public void onDouble(double value) {
            if (this.currentColumn != null) {
                this.writeable.writeValueHeader(this.currentColumn.columnId, this.currentColumn.columnType, this.aggregate && this.currentColumn.aggregate != null, 0);
                this.writeable.onDouble(value);
            }
        }

        public void onString(@Nonnull byte[] bytes, int offset, int length) {
            if (this.currentColumn != null) {
                if (this.currentColumn.columnType == ColumnValueType.STRING) {
                    this.onBytesDirect(bytes);
                } else {
                    if (this.currentColumn.columnType != ColumnValueType.ANY && this.currentColumn.columnType != ColumnValueType.COMPOSITE) {
                        throw new IllegalStateException("Unexpected type: " + this.currentColumn.columnType.getName());
                    }
                    ByteArrayOutputStream output = new ByteArrayOutputStream(bytes.length + 1 + 4);
                    try (ClosableYsonConsumer binarySerializer = YTreeBinarySerializer.getSerializer((OutputStream)output);){
                        binarySerializer.onString(bytes, offset, length);
                    }
                    this.onBytesDirect(output.toByteArray());
                }
            }
        }

        void onBytesDirect(byte[] bytes) {
            if (this.currentColumn != null) {
                this.writeable.writeValueHeader(this.currentColumn.columnId, this.currentColumn.columnType, this.aggregate && this.currentColumn.aggregate != null, bytes.length);
                this.writeable.onBytes(bytes);
            }
        }
    }

    protected static class YTreeConsumerProxy
    implements YsonConsumer {
        private final YTreeConsumerDirect direct;
        private ByteArrayOutputStream output;
        private ClosableYsonConsumer binarySerializer;
        private YsonConsumer current;
        private int level;

        protected YTreeConsumerProxy(TableSchema tableSchema) {
            this.direct = new YTreeConsumerDirect(tableSchema);
        }

        YsonConsumer wrap(WireProtocolWriteable writeable, boolean aggregate) {
            this.direct.wrap(writeable, aggregate);
            this.current = null;
            this.binarySerializer = null;
            this.level = 0;
            return this;
        }

        void updateSchema(TRowsetDescriptor schemaDelta) {
            this.direct.updateSchema(schemaDelta);
        }

        void complete() {
            this.direct.complete();
        }

        private void registerBinarySerializer() {
            if (this.binarySerializer != null) {
                throw new IllegalStateException("Binary serializer must be empty at this state");
            }
            if (this.output == null) {
                this.output = new ByteArrayOutputStream(256);
            } else {
                this.output.reset();
            }
            this.binarySerializer = YTreeBinarySerializer.getSerializer((OutputStream)this.output, (int)64);
            this.current = this.binarySerializer;
        }

        private void unregisterBinarySerializer() {
            this.current = this.direct;
            this.binarySerializer.close();
            this.direct.onBytesDirect(this.output.toByteArray());
            this.binarySerializer = null;
        }

        public void onUnsignedInteger(long value) {
            this.current.onUnsignedInteger(value);
        }

        public void onString(@Nonnull String value) {
            this.current.onString(value);
        }

        public void onListItem() {
            this.current.onListItem();
        }

        public void onBeginList() {
            if (this.level == 1) {
                this.registerBinarySerializer();
            }
            this.current.onBeginList();
            ++this.level;
        }

        public void onEndList() {
            --this.level;
            this.current.onEndList();
            if (this.level == 1) {
                this.unregisterBinarySerializer();
            }
        }

        public void onBeginAttributes() {
            this.current.onBeginAttributes();
        }

        public void onEndAttributes() {
            this.current.onEndAttributes();
        }

        public void onBeginMap() {
            if (this.level == 0) {
                this.current = this.direct;
            } else if (this.level == 1) {
                this.registerBinarySerializer();
                this.current.onBeginMap();
            } else if (this.level > 1) {
                this.current.onBeginMap();
            }
            ++this.level;
        }

        public void onEndMap() {
            --this.level;
            if (this.level == 1) {
                this.current.onEndMap();
                this.unregisterBinarySerializer();
            } else if (this.level > 1) {
                this.current.onEndMap();
            }
        }

        public void onKeyedItem(@Nonnull byte[] value, int offset, int length) {
            this.onKeyedItem(new String(value, offset, length, StandardCharsets.UTF_8));
        }

        public void onKeyedItem(@Nonnull String key) {
            this.current.onKeyedItem(key);
        }

        public void onEntity() {
            this.current.onEntity();
        }

        public void onInteger(long value) {
            this.current.onInteger(value);
        }

        public void onBoolean(boolean value) {
            this.current.onBoolean(value);
        }

        public void onDouble(double value) {
            this.current.onDouble(value);
        }

        public void onString(@Nonnull byte[] bytes, int offset, int length) {
            this.current.onString(bytes, offset, length);
        }
    }
}

