/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.util.Objects;
import java.util.Optional;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponseHandler;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcClientWrapper;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.client.rpc.ServiceTicketAuth;
import tech.ytsaurus.client.rpc.UserTicketAuth;
import tech.ytsaurus.client.rpc.YTsaurusClientAuth;
import tech.ytsaurus.rpc.TCredentialsExt;
import tech.ytsaurus.rpc.TRequestHeader;

public class AuthenticationWrapper
extends RpcClientWrapper {
    private final YTsaurusClientAuth clientAuth;

    public AuthenticationWrapper(RpcClient client, YTsaurusClientAuth auth) {
        super(client);
        this.clientAuth = Objects.requireNonNull(auth);
    }

    @Override
    public RpcClient withAuthentication(YTsaurusClientAuth auth) {
        return new AuthenticationWrapper(this.innerClient, auth);
    }

    private void patchHeader(TRequestHeader.Builder header) {
        if (!header.hasUser()) {
            this.clientAuth.getUser().ifPresent(arg_0 -> ((TRequestHeader.Builder)header).setUser(arg_0));
        }
        if (header.hasExtension(TCredentialsExt.credentialsExt)) {
            return;
        }
        TCredentialsExt.Builder credentialsExtBuilder = TCredentialsExt.newBuilder();
        Optional<ServiceTicketAuth> serviceTicketAuth = this.clientAuth.getServiceTicketAuth();
        Optional<UserTicketAuth> userTicketAuth = this.clientAuth.getUserTicketAuth();
        if (serviceTicketAuth.isPresent()) {
            credentialsExtBuilder.setServiceTicket(serviceTicketAuth.get().issueServiceTicket());
        } else if (userTicketAuth.isPresent()) {
            credentialsExtBuilder.setUserTicket(userTicketAuth.get().issueUserTicket());
        } else {
            this.clientAuth.getToken().ifPresent(arg_0 -> ((TCredentialsExt.Builder)credentialsExtBuilder).setToken(arg_0));
        }
        header.setExtension(TCredentialsExt.credentialsExt, (Object)credentialsExtBuilder.build());
    }

    @Override
    public RpcClientRequestControl send(RpcClient sender, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options) {
        TRequestHeader.Builder header = request.header.toBuilder();
        this.patchHeader(header);
        return super.send(sender, request.copy(header.build()), handler, options);
    }

    @Override
    public RpcClientStreamControl startStream(RpcClient sender, RpcRequest<?> request, RpcStreamConsumer consumer, RpcOptions options) {
        TRequestHeader.Builder header = request.header.toBuilder();
        this.patchHeader(header);
        return super.startStream(sender, request.copy(header.build()), consumer, options);
    }

    @Override
    public String toString() {
        return String.valueOf(this.clientAuth.getUser()) + "@" + super.toString();
    }
}

