/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.util.EnumMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.Lz4Codec;
import tech.ytsaurus.client.rpc.NoneCodec;
import tech.ytsaurus.client.rpc.ZlibCodec;

public abstract class Codec {
    private static final Map<Compression, Supplier<Codec>> CODEC_BY_COMPRESSION = Codec.getAllCodecs();

    public abstract byte[] compress(byte[] var1);

    public abstract byte[] decompress(byte[] var1);

    private static Map<Compression, Supplier<Codec>> getAllCodecs() {
        EnumMap<Compression, Supplier<Codec>> ret = new EnumMap<Compression, Supplier<Codec>>(Compression.class);
        ret.put(Compression.Zlib_1, () -> new ZlibCodec(1));
        ret.put(Compression.Zlib_2, () -> new ZlibCodec(2));
        ret.put(Compression.Zlib_3, () -> new ZlibCodec(3));
        ret.put(Compression.Zlib_4, () -> new ZlibCodec(4));
        ret.put(Compression.Zlib_5, () -> new ZlibCodec(5));
        ret.put(Compression.Zlib_6, () -> new ZlibCodec(6));
        ret.put(Compression.Zlib_7, () -> new ZlibCodec(7));
        ret.put(Compression.Zlib_8, () -> new ZlibCodec(8));
        ret.put(Compression.Zlib_9, () -> new ZlibCodec(9));
        ret.put(Compression.Lz4, () -> new Lz4Codec(false));
        ret.put(Compression.Lz4HighCompression, () -> new Lz4Codec(true));
        ret.put(Compression.None, () -> NoneCodec.instance);
        return ret;
    }

    public static Codec codecFor(Compression compression) {
        Supplier<Codec> codecSupplier = CODEC_BY_COMPRESSION.get((Object)compression);
        if (codecSupplier == null) {
            throw new NoSuchElementException(String.format("cannot find codec for %s", new Object[]{compression}));
        }
        return codecSupplier.get();
    }
}

