/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.MessageLite;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.client.bus.Bus;
import tech.ytsaurus.client.bus.BusConnector;
import tech.ytsaurus.client.bus.BusDeliveryTracking;
import tech.ytsaurus.client.bus.BusListener;
import tech.ytsaurus.client.rpc.AcknowledgementTimeoutException;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.DefaultRpcBusClientMetricsHolder;
import tech.ytsaurus.client.rpc.DefaultRpcBusClientMetricsHolderImpl;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientRequestControl;
import tech.ytsaurus.client.rpc.RpcClientResponseHandler;
import tech.ytsaurus.client.rpc.RpcClientStreamControl;
import tech.ytsaurus.client.rpc.RpcMessageType;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.client.rpc.RpcRequestsTestingController;
import tech.ytsaurus.client.rpc.RpcStreamConsumer;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.core.common.YTsaurusError;
import tech.ytsaurus.rpc.TRequestCancelationHeader;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.rpc.TRequestHeaderOrBuilder;
import tech.ytsaurus.rpc.TResponseHeader;
import tech.ytsaurus.rpc.TStreamingFeedbackHeader;
import tech.ytsaurus.rpc.TStreamingParameters;
import tech.ytsaurus.rpc.TStreamingPayloadHeader;

public class DefaultRpcBusClient
implements RpcClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRpcBusClient.class);
    private final BusConnector busConnector;
    private final SocketAddress address;
    private final String addressString;
    private final Lock sessionLock = new ReentrantLock();
    private Session currentSession;
    private boolean closed;
    private final String destinationName;
    private final String name;
    private final DefaultRpcBusClientMetricsHolder metricsHolder = new DefaultRpcBusClientMetricsHolderImpl();
    private final AtomicInteger referenceCounter = new AtomicInteger(1);
    private final Statistics stats;

    public DefaultRpcBusClient(BusConnector busConnector, InetSocketAddress address) {
        this(busConnector, address, address.getHostName());
    }

    public DefaultRpcBusClient(BusConnector busConnector, InetSocketAddress address, String destinationName) {
        this(busConnector, address, address.getHostString() + ":" + address.getPort(), destinationName);
    }

    public DefaultRpcBusClient(BusConnector busConnector, SocketAddress address, String destinationName) {
        this(busConnector, address, address.toString(), destinationName);
    }

    public DefaultRpcBusClient(BusConnector busConnector, SocketAddress address, String addressString, String destinationName) {
        this.busConnector = Objects.requireNonNull(busConnector);
        this.address = Objects.requireNonNull(address);
        this.addressString = addressString;
        this.destinationName = destinationName;
        this.name = String.format("%s@%d", destinationName, System.identityHashCode(this));
        this.stats = new Statistics(this.destinationName());
    }

    private void discardSession(Session session) {
        this.sessionLock.lock();
        try {
            if (this.currentSession == session) {
                this.currentSession = null;
            }
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    @Override
    public String destinationName() {
        return this.destinationName;
    }

    @Override
    public String getAddressString() {
        return this.addressString;
    }

    public String toString() {
        return this.name;
    }

    private Session getSession() {
        this.sessionLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Client is closed");
            }
            Session session = this.currentSession;
            if (session == null) {
                this.currentSession = session = new Session();
                this.currentSession.start();
            }
            Session session2 = session;
            return session2;
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    @Override
    public void ref() {
        int oldValue = this.referenceCounter.getAndIncrement();
        if (oldValue <= 0) {
            throw new IllegalStateException("Trying to ref dead object");
        }
    }

    @Override
    public void unref() {
        int newValue = this.referenceCounter.decrementAndGet();
        if (newValue < 0) {
            throw new IllegalStateException("Trying to unref dead object");
        }
        if (newValue == 0) {
            this.close();
        }
    }

    @Override
    public void close() {
        logger.debug("Closing RpcClient: {}", (Object)this);
        this.sessionLock.lock();
        try {
            this.closed = true;
            if (this.currentSession != null) {
                this.currentSession.stop();
                this.currentSession = null;
            }
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    @Override
    public RpcClientRequestControl send(RpcClient sender, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options) {
        Request pendingRequest = new Request(sender, this.getSession(), request, handler, options, this.stats);
        pendingRequest.start();
        return pendingRequest;
    }

    @Override
    public RpcClientStreamControl startStream(RpcClient sender, RpcRequest<?> request, RpcStreamConsumer consumer, RpcOptions options) {
        StreamingRequest pendingRequest = new StreamingRequest(sender, this.getSession(), request, consumer, options, this.stats);
        pendingRequest.start();
        return pendingRequest;
    }

    @Override
    public ScheduledExecutorService executor() {
        return this.getSession().eventLoop();
    }

    private static class StreamingRequest
    extends RequestBase
    implements RpcClientStreamControl {
        final RpcStreamConsumer consumer;
        final AtomicInteger sequenceNumber = new AtomicInteger(0);
        Duration readTimeout;
        Duration writeTimeout;
        ScheduledFuture<?> readTimeoutFuture = null;
        ScheduledFuture<?> writeTimeoutFuture = null;

        StreamingRequest(RpcClient sender, Session session, RpcRequest<?> request, RpcStreamConsumer consumer, RpcOptions options, Statistics stat) {
            super(sender, session, request, options, stat);
            this.consumer = consumer;
            this.readTimeout = options.getStreamingReadTimeout().orElse(null);
            this.writeTimeout = options.getStreamingWriteTimeout().orElse(null);
            this.resetWriteTimeout();
            this.resetReadTimeout();
            this.setStreamingOptions();
        }

        @Override
        public void start() {
            super.start();
            this.consumer.onStartStream(this);
        }

        private void setStreamingOptions() {
            this.requestHeader.clearTimeout();
            TStreamingParameters.Builder builder = TStreamingParameters.newBuilder();
            if (this.readTimeout != null) {
                builder.setReadTimeout(RpcUtil.durationToMicros(this.readTimeout));
            }
            if (this.writeTimeout != null) {
                builder.setWriteTimeout(RpcUtil.durationToMicros(this.writeTimeout));
            }
            builder.setWindowSize((long)this.options.getStreamingWindowSize());
            this.requestHeader.setServerAttachmentsStreamingParameters(builder);
        }

        @Override
        void handleError(Throwable cause) {
            logger.info("Error in RPC protocol: `{}`", (Object)cause.getMessage(), (Object)cause);
            this.lock.lock();
            try {
                this.consumer.onError(cause);
            }
            catch (Throwable e) {
                logger.error("Error", e);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        void handleCancellation(CancellationException cancel) {
            this.lock.lock();
            try {
                this.consumer.onCancel(cancel);
            }
            catch (Throwable e) {
                logger.error("Error", e);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void clearReadTimeout() {
            if (this.readTimeoutFuture != null) {
                this.readTimeoutFuture.cancel(false);
            }
            this.readTimeout = null;
        }

        private void clearWriteTimeout() {
            if (this.writeTimeoutFuture != null) {
                this.writeTimeoutFuture.cancel(false);
            }
            this.writeTimeout = null;
        }

        private void resetReadTimeout() {
            if (this.readTimeout != null) {
                if (this.readTimeoutFuture != null) {
                    this.readTimeoutFuture.cancel(false);
                }
                this.readTimeoutFuture = this.session.eventLoop().schedule(this::handleTimeout, this.readTimeout.toNanos(), TimeUnit.NANOSECONDS);
            }
        }

        private void resetWriteTimeout() {
            if (this.writeTimeout != null) {
                if (this.writeTimeoutFuture != null) {
                    this.writeTimeoutFuture.cancel(false);
                }
                this.writeTimeoutFuture = this.session.eventLoop().schedule(this::handleTimeout, this.writeTimeout.toNanos(), TimeUnit.NANOSECONDS);
            }
        }

        @Override
        public Compression getExpectedPayloadCompression() {
            if (this.requestHeader.hasRequestCodec()) {
                return Compression.fromValue(this.requestHeader.getRequestCodec());
            }
            return Compression.None;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void streamingPayload(TStreamingPayloadHeader header, List<byte[]> attachments) {
            Duration elapsed = Duration.between(this.started, Instant.now());
            this.stat.updateResponse(elapsed.toMillis());
            this.lock.lock();
            try {
                if (this.state == RequestState.INITIALIZING) {
                    logger.error("Received response to {} before sending the request", (Object)this);
                    return;
                }
                if (this.state == RequestState.FINISHED) {
                    return;
                }
            }
            finally {
                this.resetWriteTimeout();
                this.lock.unlock();
            }
            try {
                this.lock.lock();
                this.consumer.onPayload(this.sender, header, attachments);
            }
            catch (Throwable e) {
                this.handleError(e);
                this.session.unregister(this);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void streamingFeedback(TStreamingFeedbackHeader header, List<byte[]> attachments) {
            Duration elapsed = Duration.between(this.started, Instant.now());
            this.stat.updateResponse(elapsed.toMillis());
            this.lock.lock();
            try {
                if (this.state == RequestState.INITIALIZING) {
                    logger.error("Received response to {} before sending the request", (Object)this);
                    return;
                }
                if (this.state == RequestState.FINISHED) {
                    return;
                }
            }
            finally {
                this.resetReadTimeout();
                this.lock.unlock();
            }
            try {
                this.lock.lock();
                this.consumer.onFeedback(this.sender, header, attachments);
            }
            catch (Throwable e) {
                this.handleError(e);
                this.session.unregister(this);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void finishLocked() {
            this.clearReadTimeout();
            this.clearWriteTimeout();
            this.state = RequestState.FINISHED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(TResponseHeader header, List<byte[]> attachments) {
            super.response(header, attachments);
            try {
                this.lock.lock();
                this.consumer.onResponse(this.sender, header, attachments);
            }
            catch (Throwable e) {
                this.handleError(e);
            }
            finally {
                this.session.unregister(this);
                this.lock.unlock();
            }
        }

        @Override
        public CompletableFuture<Void> feedback(long offset) {
            TStreamingFeedbackHeader.Builder builder = TStreamingFeedbackHeader.newBuilder();
            builder.setRequestId(this.requestHeader.getRequestId());
            builder.setService(this.requestHeader.getService());
            builder.setMethod(this.requestHeader.getMethod());
            if (this.requestHeader.hasRealmId()) {
                builder.setRealmId(this.requestHeader.getRealmId());
            }
            builder.setReadPosition(offset);
            return this.session.bus.send(Collections.singletonList(RpcUtil.createMessageHeader(RpcMessageType.STREAMING_FEEDBACK, (MessageLite)builder.build())), BusDeliveryTracking.NONE);
        }

        @Override
        public CompletableFuture<Void> sendEof() {
            TStreamingPayloadHeader.Builder builder = TStreamingPayloadHeader.newBuilder();
            builder.setRequestId(this.requestHeader.getRequestId());
            builder.setService(this.requestHeader.getService());
            builder.setMethod(this.requestHeader.getMethod());
            builder.setSequenceNumber(this.sequenceNumber.getAndIncrement());
            if (this.requestHeader.hasRealmId()) {
                builder.setRealmId(this.requestHeader.getRealmId());
            }
            return this.session.bus.send(RpcUtil.createEofMessage(builder.build()), BusDeliveryTracking.NONE).thenAccept(unused -> {
                this.lock.lock();
                try {
                    this.clearReadTimeout();
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        private byte[] preparePayloadHeader() {
            TStreamingPayloadHeader.Builder builder = TStreamingPayloadHeader.newBuilder();
            builder.setRequestId(this.requestHeader.getRequestId());
            builder.setService(this.requestHeader.getService());
            builder.setMethod(this.requestHeader.getMethod());
            builder.setSequenceNumber(this.sequenceNumber.getAndIncrement());
            builder.setCodec(this.requestHeader.getRequestCodec());
            if (this.requestHeader.hasRealmId()) {
                builder.setRealmId(this.requestHeader.getRealmId());
            }
            return RpcUtil.createMessageHeader(RpcMessageType.STREAMING_PAYLOAD, (MessageLite)builder.build());
        }

        @Override
        public CompletableFuture<Void> sendPayload(List<byte[]> attachments) {
            ArrayList<byte[]> message = new ArrayList<byte[]>(1 + attachments.size());
            message.add(this.preparePayloadHeader());
            message.addAll(attachments);
            return this.session.bus.send(message, BusDeliveryTracking.NONE).thenAccept(unused -> {
                this.lock.lock();
                try {
                    this.resetReadTimeout();
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        private void doConsumerWakeup() {
            try {
                this.consumer.onWakeup();
            }
            catch (Throwable ex) {
                this.error(ex);
            }
        }

        @Override
        public void wakeUp() {
            this.session.eventLoop().schedule(this::doConsumerWakeup, 0L, TimeUnit.MILLISECONDS);
        }

        @Override
        public String getRpcProxyAddress() {
            return this.sender.getAddressString();
        }
    }

    private static class Request
    extends RequestBase {
        protected final RpcClientResponseHandler handler;

        Request(RpcClient sender, Session session, RpcRequest<?> request, RpcClientResponseHandler handler, RpcOptions options, Statistics stat) {
            super(sender, session, request, options, stat);
            this.handler = Objects.requireNonNull(handler);
        }

        @Override
        public void handleError(Throwable error) {
            this.handler.onError(error);
        }

        @Override
        void handleCancellation(CancellationException cancel) {
            this.handler.onCancel(cancel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(TResponseHeader header, List<byte[]> attachments) {
            super.response(header, attachments);
            try {
                try {
                    this.handler.onResponse(this.sender, header, attachments);
                }
                catch (Throwable e) {
                    this.handler.onError(e);
                }
            }
            finally {
                this.session.unregister(this);
            }
        }
    }

    private static abstract class RequestBase
    implements RpcClientRequestControl {
        protected final Lock lock = new ReentrantLock();
        protected RequestState state = RequestState.INITIALIZING;
        protected final RpcClient sender;
        protected final Session session;
        protected final RpcRequest<?> rpcRequest;
        protected final TRequestHeader.Builder requestHeader;
        protected final GUID requestId;
        protected Instant started;
        protected final Statistics stat;
        protected final RpcOptions options;
        private final String description;
        protected ScheduledFuture<?> timeoutFuture;
        private ScheduledFuture<?> ackTimeoutFuture;

        RequestBase(RpcClient sender, Session session, RpcRequest<?> rpcRequest, RpcOptions options, Statistics stat) {
            this.sender = Objects.requireNonNull(sender);
            this.session = Objects.requireNonNull(session);
            Objects.requireNonNull(rpcRequest);
            this.rpcRequest = Objects.requireNonNull(rpcRequest);
            this.requestHeader = rpcRequest.header.toBuilder();
            this.requestId = RpcUtil.fromProto((TGuidOrBuilder)rpcRequest.header.getRequestId());
            this.stat = stat;
            this.options = Objects.requireNonNull(options);
            this.description = String.format("%s/%s/%s", this.requestHeader.getService(), this.requestHeader.getMethod(), this.requestId);
        }

        public String toString() {
            return this.description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void response(TResponseHeader header, List<byte[]> attachments) {
            Duration elapsed = Duration.between(this.started, Instant.now());
            this.stat.updateResponse(elapsed.toMillis());
            logger.debug("Request `{}` finished in {} ms Session: {}", new Object[]{this, elapsed.toMillis(), this.session});
            this.lock.lock();
            try {
                if (this.state == RequestState.INITIALIZING) {
                    logger.error("Received response to {} before sending the request", (Object)this);
                    return;
                }
                if (this.state == RequestState.FINISHED) {
                    return;
                }
                this.finishLocked();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void streamingPayload(TStreamingPayloadHeader header, List<byte[]> attachments) {
            throw new IllegalArgumentException();
        }

        public void streamingFeedback(TStreamingFeedbackHeader header, List<byte[]> attachments) {
            throw new IllegalArgumentException();
        }

        abstract void handleError(Throwable var1);

        void handleAcknowledgement() {
            logger.trace("Ack {}", (Object)this.requestId);
            this.lock.lock();
            try {
                if (this.ackTimeoutFuture != null) {
                    this.ackTimeoutFuture.cancel(true);
                    this.ackTimeoutFuture = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        abstract void handleCancellation(CancellationException var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            try {
                this.lock.lock();
                try {
                    if (this.state != RequestState.INITIALIZING) {
                        throw new IllegalStateException("Request has been started already");
                    }
                    this.state = RequestState.SENDING;
                }
                finally {
                    this.lock.unlock();
                }
                this.started = Instant.now();
                this.requestHeader.setStartTime(RpcUtil.instantToMicros(this.started));
                logger.debug("Sending request `{}` Session: {}", (Object)this, (Object)this.session);
                this.session.register(this);
                BusDeliveryTracking level = this.options.getDefaultRequestAck() ? BusDeliveryTracking.FULL : BusDeliveryTracking.SENT;
                TRequestHeader builtRequestHeader = this.requestHeader.build();
                RpcRequestsTestingController rpcRequestsTestingController = this.options.getTestingOptions().getRpcRequestsTestingController();
                if (rpcRequestsTestingController != null) {
                    rpcRequestsTestingController.addRequest(builtRequestHeader, this.rpcRequest.body);
                }
                List<byte[]> message = this.rpcRequest.serialize(builtRequestHeader);
                this.session.bus.send(message, level).whenComplete((ignored, exception) -> {
                    Duration elapsed = Duration.between(this.started, Instant.now());
                    this.stat.updateAck(elapsed.toMillis());
                    if (exception != null) {
                        this.error((Throwable)exception);
                        logger.debug("({}) request `{}` acked in {} ms with error `{}`", new Object[]{this.session, this, elapsed.toMillis(), exception.toString()});
                    } else {
                        this.ack();
                        logger.trace("Request `{}` acked in {} ms", (Object)this, (Object)elapsed.toMillis());
                    }
                });
                Duration timeout = RpcRequest.getTimeout((TRequestHeaderOrBuilder)this.requestHeader);
                Duration acknowledgementTimeout = this.options.getAcknowledgementTimeout().orElse(null);
                this.lock.lock();
                try {
                    if (timeout != null && this.state != RequestState.FINISHED) {
                        this.timeoutFuture = this.session.eventLoop().schedule(this::handleTimeout, timeout.toNanos(), TimeUnit.NANOSECONDS);
                    }
                    if (acknowledgementTimeout != null && this.options.getDefaultRequestAck() && this.state.step < RequestState.ACKED.step) {
                        this.ackTimeoutFuture = this.session.eventLoop().schedule(this::onAcknowledgementTimeout, acknowledgementTimeout.toNanos(), TimeUnit.NANOSECONDS);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }

        protected void finishLocked() {
            this.state = RequestState.FINISHED;
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
                this.timeoutFuture = null;
            }
            if (this.ackTimeoutFuture != null) {
                this.ackTimeoutFuture.cancel(false);
                this.ackTimeoutFuture = null;
            }
        }

        public CompletableFuture<Void> sendCancellation() {
            TRequestCancelationHeader.Builder builder = TRequestCancelationHeader.newBuilder();
            builder.setRequestId(this.requestHeader.getRequestId());
            builder.setService(this.requestHeader.getService());
            builder.setMethod(this.requestHeader.getMethod());
            if (this.requestHeader.hasRealmId()) {
                builder.setRealmId(this.requestHeader.getRealmId());
            }
            logger.debug("Canceling request {}", (Object)this);
            return this.session.bus.send(RpcUtil.createCancelMessage(builder.build()), BusDeliveryTracking.NONE);
        }

        public void handleTimeout() {
            this.timeout(new TimeoutException("Request timed out"));
        }

        @Override
        public boolean cancel() {
            this.lock.lock();
            try {
                if (this.state == RequestState.INITIALIZING) {
                    throw new IllegalStateException("Request has not been started");
                }
                if (this.state == RequestState.FINISHED) {
                    boolean bl = false;
                    return bl;
                }
                this.finishLocked();
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.handleCancellation(new CancellationException());
            }
            finally {
                if (this.session.unregister(this)) {
                    this.sendCancellation();
                }
            }
            return true;
        }

        public void ack() {
            this.lock.lock();
            try {
                if (this.state != RequestState.SENDING) {
                    return;
                }
                this.state = RequestState.ACKED;
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.handleAcknowledgement();
            }
            catch (Throwable e) {
                this.error(e);
            }
        }

        public void error(Throwable cause) {
            this.stat.incError();
            this.lock.lock();
            try {
                if (this.state == RequestState.FINISHED) {
                    return;
                }
                this.finishLocked();
            }
            finally {
                this.lock.unlock();
            }
            try {
                this.handleError(cause);
            }
            finally {
                this.session.unregister(this);
            }
        }

        private void timeout(TimeoutException error) {
            logger.warn("{}; RequestId: {}", (Object)error.toString(), (Object)this.requestId);
            this.sendCancellation();
            this.error(error);
        }

        private void onAcknowledgementTimeout() {
            this.lock.lock();
            try {
                if (this.state.step >= RequestState.ACKED.step) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            String message = String.format("Request acknowledgement timed out; requestId: %s; proxy: %s", this.requestId, this.sender.getAddressString());
            this.timeout(new AcknowledgementTimeoutException(message));
        }
    }

    private static enum RequestState {
        INITIALIZING(0),
        SENDING(1),
        ACKED(2),
        FINISHED(3);

        final int step;

        private RequestState(int step) {
            this.step = step;
        }
    }

    private class Session
    implements BusListener {
        private final Bus bus;
        private final ConcurrentHashMap<GUID, RequestBase> activeRequests = new ConcurrentHashMap();
        private final String sessionName;

        Session() {
            this.sessionName = String.format("Session(%s@%s)", DefaultRpcBusClient.this.addressString, Integer.toHexString(this.hashCode()));
            this.bus = DefaultRpcBusClient.this.busConnector.connect(DefaultRpcBusClient.this.address, this);
        }

        public void start() {
            this.bus.disconnected().addListener(ready -> {
                DefaultRpcBusClient.this.discardSession(this);
                this.failPending(ready.isSuccess() ? new ClosedChannelException() : ready.cause());
            });
        }

        public void stop() {
            this.bus.close();
        }

        public EventLoop eventLoop() {
            return this.bus.eventLoop();
        }

        @Override
        public void onMessage(Bus bus, List<byte[]> message) {
            RpcMessageType type;
            if (message.size() < 1) {
                throw new IllegalStateException("Received an empty message");
            }
            byte[] headerPart = message.get(0);
            try {
                type = RpcMessageType.fromValue(ByteBuffer.wrap(headerPart).order(ByteOrder.LITTLE_ENDIAN).getInt());
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Failed to read message type", e);
            }
            switch (type) {
                case RESPONSE: {
                    TResponseHeader header;
                    try {
                        header = TResponseHeader.parseFrom((CodedInputStream)CodedInputStream.newInstance((byte[])headerPart, (int)4, (int)(headerPart.length - 4)));
                    }
                    catch (IOException | RuntimeException e) {
                        throw new IllegalStateException("Failed to parse message header", e);
                    }
                    GUID requestId = RpcUtil.fromProto((TGuidOrBuilder)header.getRequestId());
                    RequestBase request = this.activeRequests.get(requestId);
                    if (request == null) {
                        logger.debug("Received response to an unknown request {}", (Object)requestId);
                        return;
                    }
                    if (header.hasError() && header.getError().getCode() != 0) {
                        request.error((Throwable)new YTsaurusError(header.getError()));
                        return;
                    }
                    request.response(header, message.subList(1, message.size()));
                    break;
                }
                case STREAMING_PAYLOAD: {
                    TStreamingPayloadHeader header;
                    try {
                        header = TStreamingPayloadHeader.parseFrom((CodedInputStream)CodedInputStream.newInstance((byte[])headerPart, (int)4, (int)(headerPart.length - 4)));
                    }
                    catch (IOException | RuntimeException e) {
                        throw new IllegalStateException("Failed to parse message header", e);
                    }
                    GUID requestId = RpcUtil.fromProto((TGuidOrBuilder)header.getRequestId());
                    RequestBase request = this.activeRequests.get(requestId);
                    if (request == null) {
                        logger.debug("Received response to an unknown request {}", (Object)requestId);
                        return;
                    }
                    request.streamingPayload(header, message.subList(1, message.size()));
                    break;
                }
                case STREAMING_FEEDBACK: {
                    TStreamingFeedbackHeader header;
                    try {
                        header = TStreamingFeedbackHeader.parseFrom((CodedInputStream)CodedInputStream.newInstance((byte[])headerPart, (int)4, (int)(headerPart.length - 4)));
                    }
                    catch (IOException | RuntimeException e) {
                        throw new IllegalStateException("Failed to parse message header", e);
                    }
                    GUID requestId = RpcUtil.fromProto((TGuidOrBuilder)header.getRequestId());
                    RequestBase request = this.activeRequests.get(requestId);
                    if (request == null) {
                        logger.debug("Received response to an unknown request {}", (Object)requestId);
                        return;
                    }
                    request.streamingFeedback(header, message.subList(1, message.size()));
                    break;
                }
                case HANDSHAKE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + String.valueOf((Object)type) + " message in a client connection");
                }
            }
        }

        @Override
        public void onConnect(Bus bus) {
        }

        @Override
        public void onDisconnect(Bus bus) {
        }

        @Override
        public void onException(Bus bus, Throwable cause) {
        }

        private void failPending(Throwable cause) {
            Iterator<RequestBase> it = this.activeRequests.values().iterator();
            while (it.hasNext()) {
                RequestBase request = it.next();
                try {
                    request.error(cause);
                }
                catch (Throwable e) {
                    logger.debug("Failed while failing an active request", e);
                }
                it.remove();
            }
        }

        public void register(RequestBase request) {
            this.activeRequests.put(request.requestId, request);
        }

        public boolean unregister(RequestBase request) {
            logger.trace("Unregister request {}", (Object)request.requestId);
            return this.activeRequests.remove(request.requestId, request);
        }

        public String toString() {
            return this.sessionName;
        }
    }

    private final class Statistics {
        private final String name;

        Statistics(String name) {
            this.name = name;
        }

        void updateAck(long millis) {
            DefaultRpcBusClient.this.metricsHolder.updateAck(this.name, millis);
        }

        void updateResponse(long millis) {
            DefaultRpcBusClient.this.metricsHolder.updateResponse(this.name, millis);
        }

        void incError() {
            DefaultRpcBusClient.this.metricsHolder.incError();
        }
    }
}

