/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import com.google.protobuf.MessageLite;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.client.rpc.RpcClientPool;
import tech.ytsaurus.client.rpc.RpcClientResponse;
import tech.ytsaurus.client.rpc.RpcOptions;
import tech.ytsaurus.client.rpc.RpcRequest;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpc.TRequestHeader;

public interface RpcClientRequestBuilder<RequestType extends MessageLite.Builder, ResponseType extends MessageLite> {
    public RequestType body();

    public List<byte[]> attachments();

    public void setCompressedAttachments(Compression var1, List<byte[]> var2);

    public CompletableFuture<RpcClientResponse<ResponseType>> invoke(RpcClient var1);

    public CompletableFuture<RpcClientResponse<ResponseType>> invokeVia(ScheduledExecutorService var1, RpcClientPool var2);

    public RpcOptions getOptions();

    public TRequestHeader.Builder header();

    public RpcRequest<?> getRpcRequest();

    default public GUID getRequestId() {
        return RpcUtil.fromProto(this.header().getRequestIdOrBuilder());
    }

    default public String getService() {
        return this.header().getService();
    }

    default public String getMethod() {
        return this.header().getMethod();
    }
}

