/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.util.HashMap;
import java.util.Map;

public enum RpcMessageType {
    REQUEST(1768124530),
    CANCEL(1667461234),
    RESPONSE(1868787826),
    STREAMING_PAYLOAD(1885565042),
    STREAMING_FEEDBACK(1717792882),
    HANDSHAKE(1752397154);

    private static final Map<Integer, RpcMessageType> TYPES;
    private final int value;

    private RpcMessageType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RpcMessageType fromValue(int value) {
        RpcMessageType type = TYPES.get(value);
        if (type == null) {
            throw new IllegalArgumentException("Unsupported rpc message type: 0x" + Integer.toUnsignedString(value, 16));
        }
        return type;
    }

    static {
        TYPES = new HashMap<Integer, RpcMessageType>();
        for (RpcMessageType type : RpcMessageType.values()) {
            TYPES.put(type.getValue(), type);
        }
    }
}

