/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import com.google.protobuf.MessageLite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcMessageType;
import tech.ytsaurus.client.rpc.RpcUtil;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpc.TRequestHeader;
import tech.ytsaurus.rpc.TRequestHeaderOrBuilder;

public class RpcRequest<RequestType extends MessageLite> {
    public final TRequestHeader header;
    public final RequestType body;
    @Nullable
    public final List<byte[]> attachments;
    @Nullable
    public final List<byte[]> compressedAttachments;
    @Nullable
    public final Compression compressedAttachmentsCodec;

    public RpcRequest(TRequestHeader header, RequestType body, @Nonnull List<byte[]> attachments) {
        this.header = header;
        this.body = body;
        this.attachments = attachments;
        this.compressedAttachments = null;
        this.compressedAttachmentsCodec = null;
    }

    public RpcRequest(TRequestHeader header, RequestType body, @Nullable Compression codec, @Nullable List<byte[]> attachments) {
        this.header = header;
        this.body = body;
        this.attachments = null;
        this.compressedAttachmentsCodec = codec;
        this.compressedAttachments = attachments;
    }

    public RpcRequest<RequestType> copy(TRequestHeader header) {
        if (this.attachments != null) {
            return new RpcRequest<RequestType>(header, this.body, this.attachments);
        }
        return new RpcRequest<RequestType>(header, this.body, this.compressedAttachmentsCodec, this.compressedAttachments);
    }

    public static Duration getTimeout(TRequestHeaderOrBuilder header) {
        if (header.hasTimeout()) {
            return RpcUtil.durationFromMicros(header.getTimeout());
        }
        return null;
    }

    public static GUID getRequestId(TRequestHeaderOrBuilder header) {
        return RpcUtil.fromProto((TGuidOrBuilder)header.getRequestId());
    }

    List<byte[]> serialize(TRequestHeader header) {
        Compression attachmentsCodec = header.hasRequestCodec() ? Compression.fromValue(header.getRequestCodec()) : Compression.fromValue(0);
        ArrayList<byte[]> message = new ArrayList<byte[]>(2 + Math.max(this.attachments != null ? this.attachments.size() : 0, this.compressedAttachments != null ? this.compressedAttachments.size() : 0));
        message.add(RpcUtil.createMessageHeader(RpcMessageType.REQUEST, (MessageLite)header));
        message.add(header.hasRequestCodec() ? RpcUtil.createMessageBodyWithCompression(this.body, Compression.fromValue(header.getRequestCodec())) : RpcUtil.createMessageBodyWithEnvelope(this.body));
        if (this.compressedAttachments != null) {
            if (this.compressedAttachmentsCodec != attachmentsCodec) {
                throw new IllegalArgumentException("Rpc compression codec doesn't match precomressed attachments compression codec");
            }
            message.addAll(this.compressedAttachments);
        } else if (this.attachments != null) {
            message.addAll(RpcUtil.createCompressedAttachments(this.attachments, attachmentsCodec));
        }
        return message;
    }

    public String toString() {
        return String.format("%s (RequestId: %s)", this.header.getMethod(), RpcRequest.getRequestId((TRequestHeaderOrBuilder)this.header));
    }
}

