/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import tech.ytsaurus.TGuid;
import tech.ytsaurus.TGuidOrBuilder;
import tech.ytsaurus.TSerializedMessageEnvelope;
import tech.ytsaurus.client.rpc.Codec;
import tech.ytsaurus.client.rpc.Compression;
import tech.ytsaurus.client.rpc.RpcMessageType;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpc.TRequestCancelationHeader;
import tech.ytsaurus.rpc.TStreamingPayloadHeader;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class RpcUtil {
    public static final long MICROS_PER_SECOND = 1000000L;
    public static final long NANOS_PER_MICROSECOND = 1000L;

    private RpcUtil() {
    }

    public static byte[] createMessageHeader(RpcMessageType type, MessageLite header) {
        int size = header.getSerializedSize();
        byte[] data = new byte[4 + size];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).putInt(type.getValue());
        try {
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])data, (int)4, (int)size);
            header.writeTo(output);
            output.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return data;
    }

    public static byte[] createMessageBodyWithCompression(MessageLite body, Compression codecId) {
        Codec codec = Codec.codecFor(codecId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CodedOutputStream output = CodedOutputStream.newInstance((OutputStream)baos);
        try {
            body.writeTo(output);
            output.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return codec.compress(baos.toByteArray());
    }

    public static int attachmentSize(byte[] attachment) {
        if (attachment == null) {
            return 1;
        }
        return attachment.length;
    }

    public static byte[] createMessageBodyWithEnvelope(MessageLite body) {
        TSerializedMessageEnvelope header = TSerializedMessageEnvelope.getDefaultInstance();
        int headerSize = header.getSerializedSize();
        int bodySize = body.getSerializedSize();
        byte[] data = new byte[8 + headerSize + bodySize];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).putInt(headerSize).putInt(bodySize);
        try {
            CodedOutputStream output = CodedOutputStream.newInstance((byte[])data, (int)8, (int)(data.length - 8));
            header.writeTo(output);
            body.writeTo(output);
            output.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return data;
    }

    public static <T> T parseMessageBodyWithCompression(byte[] data, Parser<T> parser, Compression compression) {
        try {
            Codec codec = Codec.codecFor(compression);
            byte[] decompressed = codec.decompress(data);
            return (T)parser.parseFrom(decompressed);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T parseMessageBodyWithEnvelope(byte[] data, Parser<T> parser) {
        if (data == null || data.length < 8) {
            throw new IllegalStateException("Missing fixed envelope header");
        }
        ByteBuffer buffer = ByteBuffer.wrap(data, 0, 8).order(ByteOrder.LITTLE_ENDIAN);
        int headerSize = buffer.getInt();
        int bodySize = buffer.getInt();
        if (headerSize < 0 || bodySize < 0 || 8 + headerSize + bodySize > data.length) {
            throw new IllegalStateException("Corrupted fixed envelope header");
        }
        try {
            CodedInputStream input = CodedInputStream.newInstance((byte[])data, (int)8, (int)headerSize);
            TSerializedMessageEnvelope header = TSerializedMessageEnvelope.parseFrom((CodedInputStream)input);
            if (header.getCodec() != 0) {
                throw new IllegalStateException("Compression codecs are not supported: message body has codec=" + header.getCodec());
            }
            return (T)parser.parseFrom(data, 8 + headerSize, bodySize);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<byte[]> createCompressedAttachments(List<byte[]> attachments, Compression codecId) {
        if (codecId == Compression.None || attachments.isEmpty()) {
            return attachments;
        }
        Codec codec = Codec.codecFor(codecId);
        return attachments.stream().map(codec::compress).collect(Collectors.toList());
    }

    public static List<byte[]> createCancelMessage(TRequestCancelationHeader header) {
        return Collections.singletonList(RpcUtil.createMessageHeader(RpcMessageType.CANCEL, (MessageLite)header));
    }

    public static List<byte[]> createEofMessage(TStreamingPayloadHeader header) {
        ArrayList<byte[]> message = new ArrayList<byte[]>(2);
        message.add(RpcUtil.createMessageHeader(RpcMessageType.STREAMING_PAYLOAD, (MessageLite)header));
        message.add(null);
        return message;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    public static <T> void relayCancel(CompletableFuture<T> src, Future<?> dst) {
        if (src.isDone()) {
            if (!dst.isDone()) {
                dst.cancel(false);
            }
        } else {
            src.whenComplete((ignoredResult, ignoredFailure) -> {
                if (!dst.isDone()) {
                    dst.cancel(false);
                }
            });
        }
    }

    public static <T, U> void relayApply(CompletableFuture<U> f, T value, Throwable exception, Function<? super T, ? extends U> fn) {
        if (!f.isDone()) {
            if (exception != null) {
                f.completeExceptionally(exception);
            } else {
                try {
                    f.complete(fn.apply(value));
                }
                catch (Throwable e) {
                    f.completeExceptionally(e);
                }
            }
        }
    }

    public static <T, U> CompletableFuture<U> apply(CompletableFuture<T> f, Function<? super T, ? extends U> fn) {
        CompletableFuture result = new CompletableFuture();
        if (f.isDone()) {
            try {
                result.complete(fn.apply(f.get()));
            }
            catch (Throwable e2) {
                result.completeExceptionally(e2);
            }
        } else {
            f.whenComplete((r, e) -> RpcUtil.relayApply(result, r, e, fn));
        }
        RpcUtil.relayCancel(result, f);
        return result;
    }

    public static <T, U> CompletableFuture<U> applyAsync(CompletableFuture<T> f, Function<? super T, ? extends U> fn, Executor executor) {
        CompletableFuture result = new CompletableFuture();
        f.whenCompleteAsync((r, e) -> RpcUtil.relayApply(result, r, e, fn), executor);
        RpcUtil.relayCancel(result, f);
        return result;
    }

    @Nonnull
    public static <T> CompletableFuture<T> withTimeout(@Nonnull CompletableFuture<T> f, @Nonnull String errorMessage, long delay, @Nonnull TimeUnit timeUnit, @Nonnull ScheduledExecutorService scheduledExecutorService) {
        if (!f.isDone()) {
            ScheduledFuture<Boolean> cancelFuture = scheduledExecutorService.schedule(() -> f.completeExceptionally(new TimeoutException(errorMessage)), delay, timeUnit);
            f.whenComplete((result, error) -> cancelFuture.cancel(false));
        }
        return f;
    }

    public static long durationToMicros(Duration duration) {
        long micros = Math.multiplyExact(duration.getSeconds(), 1000000L);
        micros = Math.addExact(micros, (long)duration.getNano() / 1000L);
        return micros;
    }

    public static Duration durationFromMicros(long micros) {
        long seconds = micros / 1000000L;
        long nanos = micros % 1000000L * 1000L;
        return Duration.ofSeconds(seconds, nanos);
    }

    public static long instantToMicros(Instant instant) {
        long micros = Math.multiplyExact(instant.getEpochSecond(), 1000000L);
        micros = Math.addExact(micros, (long)instant.getNano() / 1000L);
        return micros;
    }

    public static Instant instantFromMicros(long micros) {
        long seconds = micros / 1000000L;
        long nanos = micros % 1000000L * 1000L;
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public static TGuid toProto(GUID guid) {
        return TGuid.newBuilder().setFirst(guid.getFirst()).setSecond(guid.getSecond()).build();
    }

    public static GUID fromProto(TGuidOrBuilder guid) {
        return new GUID(guid.getFirst(), guid.getSecond());
    }

    public static YTreeNode parseByteString(ByteString byteString) {
        return YTreeBinarySerializer.deserialize((InputStream)byteString.newInput());
    }
}

