/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.rpc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import tech.ytsaurus.client.rpc.Codec;

class ZlibCodec
extends Codec {
    private final int level;

    ZlibCodec(int level) {
        this.level = level;
    }

    @Override
    public byte[] compress(byte[] src) {
        byte[] byArray;
        block5: {
            DeflaterOutputStream encoder = null;
            try {
                int uncompressedSize = src.length;
                byte[] header = new byte[8];
                ByteBuffer.wrap(header).order(ByteOrder.LITTLE_ENDIAN).putLong(uncompressedSize);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(header);
                encoder = new DeflaterOutputStream((OutputStream)baos, new Deflater(this.level));
                ZlibCodec.copy(new ByteArrayInputStream(src), encoder);
                encoder.flush();
                encoder.close();
                byArray = baos.toByteArray();
                if (encoder == null) break block5;
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException(ex);
                }
                catch (Throwable throwable) {
                    if (encoder != null) {
                        ZlibCodec.closeQuietly(encoder);
                    }
                    throw throwable;
                }
            }
            ZlibCodec.closeQuietly(encoder);
        }
        return byArray;
    }

    @Override
    public byte[] decompress(byte[] src) {
        byte[] byArray;
        InflaterInputStream decoder = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(src);
            byte[] header = new byte[8];
            int ret = bais.read(header);
            if (ret != 8) {
                throw new IllegalArgumentException(String.format("broken stream (read %d bytes)", ret));
            }
            long uncompressedSize = ByteBuffer.wrap(header).order(ByteOrder.LITTLE_ENDIAN).getLong();
            decoder = new InflaterInputStream(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ZlibCodec.copy(decoder, baos);
            byte[] result = baos.toByteArray();
            if ((long)result.length != uncompressedSize) {
                throw new IllegalArgumentException("broken stream");
            }
            byArray = result;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                ZlibCodec.closeQuietly(decoder);
                throw throwable;
            }
        }
        ZlibCodec.closeQuietly(decoder);
        return byArray;
    }

    private static long copy(InputStream inputStream, OutputStream outputStream) {
        try {
            byte[] bytes = new byte[65536];
            long totalCopied = 0L;
            while (true) {
                int count;
                if ((count = inputStream.read(bytes)) < 0) {
                    return totalCopied;
                }
                outputStream.write(bytes, 0, count);
                totalCopied += (long)count;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void closeQuietly(@Nullable Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Throwable ex) {
                    if (!(ex instanceof VirtualMachineError) || !(ex instanceof OutOfMemoryError) && !(ex instanceof InternalError) && !(ex instanceof UnknownError)) break block3;
                    throw (VirtualMachineError)ex;
                }
            }
        }
    }
}

