/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.sync;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.client.RetryPolicy;
import tech.ytsaurus.client.request.MountTable;
import tech.ytsaurus.client.request.UnmountTable;
import tech.ytsaurus.client.sync.SyncApiServiceClientImpl;
import tech.ytsaurus.client.sync.SyncApiServiceTransaction;
import tech.ytsaurus.client.sync.SyncCompoundClient;

abstract class SyncCompoundClientImpl
extends SyncApiServiceClientImpl
implements SyncCompoundClient {
    private final CompoundClient client;
    private final ExecutorService executorForUserTasks;

    SyncCompoundClientImpl(CompoundClient client) {
        super(client);
        this.client = client;
        this.executorForUserTasks = Executors.newCachedThreadPool();
    }

    @Override
    public <T> T retryWithTabletTransaction(Function<SyncApiServiceTransaction, T> action, RetryPolicy retryPolicy) {
        Function asyncAction = transaction -> CompletableFuture.supplyAsync(() -> action.apply(SyncApiServiceTransaction.wrap(transaction)), this.executorForUserTasks);
        return this.client.retryWithTabletTransaction(asyncAction, this.executorForUserTasks, retryPolicy).join();
    }

    @Override
    public void mountTableAndWaitTablets(MountTable req) {
        this.client.mountTableAndWaitTablets(req).join();
    }

    @Override
    public void unmountTableAndWaitTablets(UnmountTable req) {
        this.client.unmountTableAndWaitTablets(req).join();
    }
}

