/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.sync;

import java.io.IOException;
import tech.ytsaurus.client.FileWriter;
import tech.ytsaurus.client.sync.SyncFileWriter;

class SyncFileWriterImpl
extends SyncFileWriter {
    private final FileWriter writer;

    private SyncFileWriterImpl(FileWriter writer) {
        this.writer = writer;
    }

    static SyncFileWriter wrap(FileWriter writer) {
        return new SyncFileWriterImpl(writer);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)});
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int offset, int len) throws IOException {
        if (!this.writer.write(data, offset, len)) {
            throw new IOException();
        }
        this.writer.readyEvent().join();
    }

    @Override
    public void close() {
        this.writer.close().join();
    }

    @Override
    public void cancel() {
        this.writer.cancel();
    }
}

