/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client.sync;

import java.util.ArrayList;
import java.util.List;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.sync.SyncTableWriter;

class SyncTableWriterImpl<T>
implements SyncTableWriter<T> {
    private static final int BUFFER_SIZE = 1024;
    private final AsyncWriter<T> writer;
    private final List<T> buf;

    private SyncTableWriterImpl(AsyncWriter<T> writer) {
        this.writer = writer;
        this.buf = new ArrayList<T>(1024);
    }

    static <T> SyncTableWriter<T> wrap(AsyncWriter<T> writer) {
        return new SyncTableWriterImpl<T>(writer);
    }

    @Override
    public void accept(T row) {
        if (this.buf.size() == 1024) {
            this.writer.write(this.buf).join();
            this.buf.clear();
        }
        this.buf.add(row);
    }

    @Override
    public void flush() {
        this.writer.write(this.buf).join();
        this.buf.clear();
    }

    @Override
    public void close() {
        this.flush();
        this.writer.finish().join();
    }

    @Override
    public void cancel() {
        this.writer.cancel();
    }
}

