/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import tech.ytsaurus.yson.BufferReference;
import tech.ytsaurus.yson.ByteZeroCopyInput;
import tech.ytsaurus.yson.YsonError;
import tech.ytsaurus.yson.ZeroCopyInput;

public class StreamReader {
    public static final int END_OF_STREAM = Integer.MAX_VALUE;
    private final ZeroCopyInput underlying;
    private final BufferReference tmp = new BufferReference();
    private byte[] buffer = BufferReference.EMPTY_BUFFER;
    private int bufferOffset = 0;
    private int bufferLength = 0;
    private byte[] largeStringBuffer = BufferReference.EMPTY_BUFFER;
    private int position = 0;

    StreamReader(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    StreamReader(byte[] buffer, int offset, int length) {
        this(new ByteZeroCopyInput(buffer, offset, length));
    }

    public StreamReader(ZeroCopyInput underlying) {
        this.underlying = underlying;
    }

    public int getPosition() {
        return this.position;
    }

    public int tryReadByte() {
        if (this.bufferOffset >= this.bufferLength && !this.nextBuffer()) {
            return Integer.MAX_VALUE;
        }
        ++this.position;
        return this.buffer[this.bufferOffset++];
    }

    public byte readByte() {
        if (this.bufferOffset >= this.bufferLength && !this.nextBuffer()) {
            this.throwUnexpectedEndOfStream();
        }
        ++this.position;
        return this.buffer[this.bufferOffset++];
    }

    public void unreadByte() {
        if (this.bufferOffset == 0) {
            throw new IllegalStateException();
        }
        --this.bufferOffset;
        --this.position;
    }

    public void readBytes(int length, BufferReference out) {
        if (this.bufferOffset + length <= this.bufferLength) {
            out.setBuffer(this.buffer);
            out.setOffset(this.bufferOffset);
            out.setLength(length);
            this.bufferOffset += length;
        } else {
            if (this.largeStringBuffer.length < length) {
                this.largeStringBuffer = new byte[length];
            }
            int pos = 0;
            while (pos < length) {
                int toCopy = Math.min(this.bufferLength - this.bufferOffset, length - pos);
                System.arraycopy(this.buffer, this.bufferOffset, this.largeStringBuffer, pos, toCopy);
                this.bufferOffset += toCopy;
                if ((pos += toCopy) >= length) break;
                if (this.nextBuffer()) continue;
                this.throwUnexpectedEndOfStream();
            }
            out.setBuffer(this.largeStringBuffer);
            out.setOffset(0);
            out.setLength(length);
        }
        this.position += length;
    }

    public long readVarUint64() {
        block5: {
            long x;
            int pos;
            block7: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block6: {
                                            byte y;
                                            pos = this.bufferOffset;
                                            if (this.bufferLength == pos) break block5;
                                            if ((y = this.buffer[pos++]) >= 0) {
                                                this.position += pos - this.bufferOffset;
                                                this.bufferOffset = pos;
                                                return y;
                                            }
                                            if (this.bufferLength - pos < 9) break block5;
                                            if ((x = (long)(y ^ this.buffer[pos++] << 7)) >= 0L) break block6;
                                            x ^= 0xFFFFFFFFFFFFFF80L;
                                            break block7;
                                        }
                                        if ((x ^= (long)(this.buffer[pos++] << 14)) < 0L) break block8;
                                        x ^= 0x3F80L;
                                        break block7;
                                    }
                                    if ((x ^= (long)(this.buffer[pos++] << 21)) >= 0L) break block9;
                                    x ^= 0xFFFFFFFFFFE03F80L;
                                    break block7;
                                }
                                if ((x ^= (long)this.buffer[pos++] << 28) < 0L) break block10;
                                x ^= 0xFE03F80L;
                                break block7;
                            }
                            if ((x ^= (long)this.buffer[pos++] << 35) >= 0L) break block11;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block7;
                        }
                        if ((x ^= (long)this.buffer[pos++] << 42) < 0L) break block12;
                        x ^= 0x3F80FE03F80L;
                        break block7;
                    }
                    if ((x ^= (long)this.buffer[pos++] << 49) >= 0L) break block13;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block7;
                }
                x ^= (long)this.buffer[pos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)this.buffer[pos++] < 0L) break block5;
            }
            this.position += pos - this.bufferOffset;
            this.bufferOffset = pos;
            return x;
        }
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new YsonError("Malformed varint");
    }

    private void throwUnexpectedEndOfStream() {
        throw new YsonError("Unexpected end of stream");
    }

    private boolean nextBuffer() {
        boolean read = this.underlying.next(this.tmp);
        if (read) {
            this.buffer = this.tmp.getBuffer();
            this.bufferOffset = this.tmp.getOffset();
            this.bufferLength = this.tmp.getLength();
        }
        return read;
    }

    public long readFixed64() {
        long bits = 0L;
        if (this.bufferOffset + 8 <= this.bufferLength) {
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF);
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF) << 8;
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF) << 16;
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF) << 24;
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF) << 32;
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF) << 40;
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF) << 48;
            bits |= (long)(this.buffer[this.bufferOffset++] & 0xFF) << 56;
            this.position += 8;
        } else {
            for (int i = 0; i < 64; i += 8) {
                bits |= (long)(this.readByte() & 0xFF) << i;
            }
        }
        return bits;
    }
}

