/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.nio.charset.StandardCharsets;

public interface YsonConsumer {
    public void onEntity();

    public void onInteger(long var1);

    public void onUnsignedInteger(long var1);

    public void onBoolean(boolean var1);

    public void onDouble(double var1);

    public void onString(byte[] var1, int var2, int var3);

    default public void onString(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.onString(bytes, 0, bytes.length);
    }

    public void onBeginList();

    public void onListItem();

    public void onEndList();

    public void onBeginAttributes();

    public void onEndAttributes();

    public void onBeginMap();

    public void onEndMap();

    public void onKeyedItem(byte[] var1, int var2, int var3);

    default public void onKeyedItem(String key) {
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        this.onKeyedItem(bytes, 0, bytes.length);
    }

    public static void onKeyedItem(YsonConsumer ysonConsumer, byte[] value) {
        ysonConsumer.onKeyedItem(value, 0, value.length);
    }

    public static void onString(YsonConsumer ysonConsumer, byte[] value) {
        ysonConsumer.onString(value, 0, value.length);
    }
}

