/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.yson;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.annotation.Nullable;
import tech.ytsaurus.yson.BufferReference;
import tech.ytsaurus.yson.BufferedStreamZeroCopyInput;
import tech.ytsaurus.yson.ByteZeroCopyInput;
import tech.ytsaurus.yson.StreamReader;
import tech.ytsaurus.yson.VarintUtils;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonError;
import tech.ytsaurus.yson.YsonLexer;
import tech.ytsaurus.yson.YsonTextUtils;
import tech.ytsaurus.yson.ZeroCopyInput;

public class YsonParser {
    private final StreamReader tokenizer;
    private final BufferReference bufferReference = new BufferReference();
    private boolean expectFragmentSeparator = false;

    public YsonParser(InputStream input) {
        this(input, 512);
    }

    public YsonParser(InputStream input, int bufferSize) {
        this(new BufferedStreamZeroCopyInput(input, bufferSize));
    }

    public YsonParser(InputStream input, byte[] buffer) {
        this(new BufferedStreamZeroCopyInput(input, buffer));
    }

    public YsonParser(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public YsonParser(byte[] buffer, int offset, int length) {
        this(new ByteZeroCopyInput(buffer, offset, length));
    }

    private YsonParser(ZeroCopyInput input) {
        this.tokenizer = new StreamReader(input);
    }

    public void parseNode(YsonConsumer consumer) {
        int maybeByte;
        byte b1 = this.tokenizer.readByte();
        this.parseNodeImpl(true, b1, consumer);
        while ((maybeByte = this.tokenizer.tryReadByte()) != Integer.MAX_VALUE) {
            byte b = (byte)maybeByte;
            if (this.isSpace(b)) continue;
            throw new YsonError(String.format("Unexpected trailing character: %s", this.debugByteString(b)));
        }
    }

    public int parseAttributes(YsonConsumer consumer) {
        byte currentByte = this.skipWhitespaces();
        if (currentByte == 60) {
            consumer.onBeginAttributes();
            this.parseMapLikeImpl((byte)62, consumer);
            consumer.onEndAttributes();
            this.skipSpaces();
        }
        this.tokenizer.unreadByte();
        return this.tokenizer.getPosition();
    }

    private byte skipWhitespaces() {
        byte currentByte = this.tokenizer.readByte();
        while (this.isSpace(currentByte)) {
            currentByte = this.tokenizer.readByte();
        }
        return currentByte;
    }

    private void skipSpaces() {
        byte currentByte = this.tokenizer.readByte();
        while (currentByte == 32) {
            currentByte = this.tokenizer.readByte();
        }
    }

    public void parseListFragment(YsonConsumer consumer) {
        int maybeByte;
        while ((maybeByte = this.moveToNextListItem(this.expectFragmentSeparator)) != Integer.MAX_VALUE) {
            consumer.onListItem();
            this.parseNodeImpl(true, (byte)maybeByte, consumer);
            this.expectFragmentSeparator = true;
        }
        return;
    }

    public boolean parseListFragmentItem(YsonConsumer consumer) {
        int maybeByte = this.moveToNextListItem(this.expectFragmentSeparator);
        if (maybeByte == Integer.MAX_VALUE) {
            return false;
        }
        this.parseNodeImpl(true, (byte)maybeByte, consumer);
        this.expectFragmentSeparator = true;
        return true;
    }

    private void parseNodeImpl(boolean allowAttributes, byte currentByte, YsonConsumer consumer) {
        while (true) {
            switch (currentByte) {
                case 1: {
                    this.readBinaryString(this.bufferReference);
                    consumer.onString(this.bufferReference.getBuffer(), this.bufferReference.getOffset(), this.bufferReference.getLength());
                    return;
                }
                case 2: {
                    long value = this.readSInt64();
                    consumer.onInteger(value);
                    return;
                }
                case 3: {
                    double value = this.readDouble();
                    consumer.onDouble(value);
                    return;
                }
                case 4: {
                    consumer.onBoolean(false);
                    return;
                }
                case 5: {
                    consumer.onBoolean(true);
                    return;
                }
                case 6: {
                    long value = this.tokenizer.readVarUint64();
                    consumer.onUnsignedInteger(value);
                    return;
                }
                case 35: {
                    consumer.onEntity();
                    return;
                }
                case 91: {
                    consumer.onBeginList();
                    this.parseListImpl(consumer);
                    consumer.onEndList();
                    return;
                }
                case 60: {
                    if (!allowAttributes) {
                        throw new YsonError("Unexpected token '<'");
                    }
                    consumer.onBeginAttributes();
                    this.parseMapLikeImpl((byte)62, consumer);
                    consumer.onEndAttributes();
                    this.parseNodeImpl(false, this.tokenizer.readByte(), consumer);
                    return;
                }
                case 123: {
                    consumer.onBeginMap();
                    this.parseMapLikeImpl((byte)125, consumer);
                    consumer.onEndMap();
                    return;
                }
                case 34: {
                    byte[] string = this.readQuotedString();
                    consumer.onString(string, 0, string.length);
                    return;
                }
                case 37: {
                    currentByte = this.tokenizer.readByte();
                    if (currentByte == 110) {
                        this.verifyLiteral(2, YsonLexer.NAN_LITERAL);
                        consumer.onDouble(Double.NaN);
                        return;
                    }
                    if (currentByte == 116) {
                        this.verifyLiteral(2, YsonLexer.TRUE_LITERAL);
                        consumer.onBoolean(true);
                        return;
                    }
                    if (currentByte == 102) {
                        this.verifyLiteral(2, YsonLexer.FALSE_LITERAL);
                        consumer.onBoolean(false);
                        return;
                    }
                    if (currentByte == 105) {
                        this.verifyLiteral(2, YsonLexer.INF_LITERAL);
                        consumer.onDouble(Double.POSITIVE_INFINITY);
                        return;
                    }
                    if (currentByte == 43) {
                        this.verifyLiteral(2, YsonLexer.PLUS_INF_LITERAL);
                        consumer.onDouble(Double.POSITIVE_INFINITY);
                        return;
                    }
                    if (currentByte == 45) {
                        this.verifyLiteral(2, YsonLexer.MINUS_INF_LITERAL);
                        consumer.onDouble(Double.NEGATIVE_INFINITY);
                        return;
                    }
                    throw new YsonError(String.format("Bad yson literal %%%s", Character.valueOf((char)currentByte)));
                }
            }
            if (!this.isSpace(currentByte)) break;
            currentByte = this.tokenizer.readByte();
        }
        byte[] string = this.tryReadUnquotedString(currentByte);
        if (string != null) {
            consumer.onString(string, 0, string.length);
            return;
        }
        if (this.tryConsumeTextNumber(currentByte, consumer)) {
            return;
        }
        throw new YsonError(String.format("Unexpected byte: %s in yson", this.debugByteString(currentByte)));
    }

    private void parseListImpl(YsonConsumer consumer) {
        boolean expectSeparator = false;
        while (true) {
            int maybeByte;
            if ((maybeByte = this.moveToNextListItem(expectSeparator)) == Integer.MAX_VALUE) {
                throw new YsonError("Unexpected end of stream");
            }
            byte b = (byte)maybeByte;
            if (b == 93) {
                return;
            }
            consumer.onListItem();
            this.parseNodeImpl(true, b, consumer);
            expectSeparator = true;
        }
    }

    private int moveToNextListItem(boolean expectSeparator) {
        byte b;
        block3: {
            while (true) {
                int maybeByte;
                if ((maybeByte = this.tokenizer.tryReadByte()) == Integer.MAX_VALUE) {
                    return maybeByte;
                }
                b = (byte)maybeByte;
                if (this.isSpace(b)) continue;
                if (!expectSeparator) break block3;
                if (b != 59) break;
                expectSeparator = false;
            }
            if (b != 93) {
                throw new YsonError(String.format("Expected yson ';' or ']', found: %s", this.debugByteString(b)));
            }
        }
        return b;
    }

    private void parseMapLikeImpl(byte endByte, YsonConsumer consumer) {
        boolean expectSeparator = false;
        while (true) {
            int maybeByte;
            if ((maybeByte = this.tokenizer.tryReadByte()) == Integer.MAX_VALUE) {
                throw new YsonError("Unexpected end of stream");
            }
            byte b = (byte)maybeByte;
            if (b == endByte) {
                return;
            }
            if (this.isSpace(b)) continue;
            if (expectSeparator) {
                if (b == 59) {
                    expectSeparator = false;
                    continue;
                }
                throw new YsonError(String.format("Expected ';' or '%s', found: %s", Character.valueOf((char)endByte), this.debugByteString(b)));
            }
            this.parseMapKey(b, consumer);
            b = this.tokenizer.readByte();
            if (b != 61) {
                while (this.isSpace(b)) {
                    b = this.tokenizer.readByte();
                }
                if (b != 61) {
                    throw new YsonError(String.format("Expected '='; found %s", this.debugByteString(b)));
                }
            }
            b = this.tokenizer.readByte();
            this.parseNodeImpl(true, b, consumer);
            expectSeparator = true;
        }
    }

    private void parseMapKey(byte currentByte, YsonConsumer consumer) {
        while (true) {
            switch (currentByte) {
                case 1: {
                    this.readBinaryString(this.bufferReference);
                    consumer.onKeyedItem(this.bufferReference.getBuffer(), this.bufferReference.getOffset(), this.bufferReference.getLength());
                    return;
                }
                case 34: {
                    byte[] string = this.readQuotedString();
                    consumer.onKeyedItem(string, 0, string.length);
                    return;
                }
            }
            if (!this.isSpace(currentByte)) break;
            currentByte = this.tokenizer.readByte();
        }
        byte[] string = this.tryReadUnquotedString(currentByte);
        if (string != null) {
            consumer.onKeyedItem(string, 0, string.length);
            return;
        }
        throw new YsonError(String.format("Expected key, found: %s byte", this.debugByteString(currentByte)));
    }

    private boolean isSpace(byte b) {
        switch (b) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private void verifyLiteral(int startIndex, char[] literal) {
        for (int i = startIndex; i < literal.length; ++i) {
            byte c = this.tokenizer.readByte();
            if (literal[i] == c) continue;
            throw new YsonError(String.format("Bad yson literal: %s", String.copyValueOf(literal, 0, i) + (char)c));
        }
    }

    private double readDouble() {
        long bits = this.tokenizer.readFixed64();
        return Double.longBitsToDouble(bits);
    }

    private long readSInt64() {
        long uint = this.tokenizer.readVarUint64();
        return VarintUtils.decodeZigZag64(uint);
    }

    private void readBinaryString(BufferReference bufferReference) {
        long stringLength = this.readSInt64();
        if (stringLength < 0L) {
            throw new YsonError(String.format("Yson string length is negative: %d", stringLength));
        }
        if (stringLength > Integer.MAX_VALUE) {
            throw new YsonError(String.format("Yson string length exceeds limit: %d > %d", stringLength, Integer.MAX_VALUE));
        }
        this.tokenizer.readBytes((int)stringLength, bufferReference);
    }

    @Nullable
    private byte[] tryReadUnquotedString(byte firstByte) {
        int maybeByte;
        boolean isUnquotedString;
        boolean bl = isUnquotedString = 97 <= firstByte && firstByte <= 122 || 65 <= firstByte && firstByte <= 90 || firstByte == 95;
        if (!isUnquotedString) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(firstByte);
        while ((maybeByte = this.tokenizer.tryReadByte()) != Integer.MAX_VALUE) {
            byte b = (byte)maybeByte;
            if (97 <= b && b <= 122 || 65 <= b && b <= 90 || 48 <= b && b <= 57 || b == 95 || b == 46 || b == 45) {
                out.write(b);
                continue;
            }
            this.tokenizer.unreadByte();
            break;
        }
        return out.toByteArray();
    }

    private boolean tryConsumeTextNumber(byte firstByte, YsonConsumer consumer) {
        int maybeByte;
        int numberType;
        boolean int64Type = false;
        boolean uint64Type = true;
        int doubleType = 2;
        if (48 <= firstByte && firstByte <= 57 || firstByte == 45 || firstByte == 43) {
            numberType = 0;
        } else if (firstByte == 46) {
            numberType = 2;
        } else {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)firstByte);
        while ((maybeByte = this.tokenizer.tryReadByte()) != Integer.MAX_VALUE) {
            byte b = (byte)maybeByte;
            if (b >= 48 && b <= 57 || b == 45 || b == 43) {
                sb.append((char)b);
                continue;
            }
            if (b == 46 || b == 101 || b == 69) {
                sb.append((char)b);
                numberType = 2;
                continue;
            }
            if (b == 117) {
                sb.append((char)b);
                numberType = 1;
                continue;
            }
            this.tokenizer.unreadByte();
            break;
        }
        switch (numberType) {
            case 0: {
                long value;
                String text = sb.toString();
                try {
                    value = Long.parseLong(text);
                }
                catch (NumberFormatException e) {
                    throw new YsonError("Error parsing int64 literal: " + text, e);
                }
                consumer.onInteger(value);
                return true;
            }
            case 1: {
                long value;
                sb.deleteCharAt(sb.length() - 1);
                String text = sb.toString();
                try {
                    value = Long.parseUnsignedLong(text);
                }
                catch (NumberFormatException e) {
                    throw new YsonError("Error parsing uint64 literal " + text, e);
                }
                consumer.onUnsignedInteger(value);
                return true;
            }
            case 2: {
                double value;
                String text = sb.toString();
                try {
                    value = Double.parseDouble(text);
                }
                catch (NumberFormatException e) {
                    throw new YsonError("Error parsing double literal " + text, e);
                }
                consumer.onDouble(value);
                return true;
            }
        }
        throw new IllegalStateException("Unexpected number type " + numberType);
    }

    private byte[] readQuotedString() {
        byte current;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        block11: while ((current = this.tokenizer.readByte()) != 34) {
            if (current != 92) {
                out.write(current);
                continue;
            }
            current = this.tokenizer.readByte();
            switch (current) {
                case 97: {
                    out.write(7);
                    continue block11;
                }
                case 98: {
                    out.write(8);
                    continue block11;
                }
                case 116: {
                    out.write(9);
                    continue block11;
                }
                case 110: {
                    out.write(10);
                    continue block11;
                }
                case 118: {
                    out.write(11);
                    continue block11;
                }
                case 102: {
                    out.write(12);
                    continue block11;
                }
                case 114: {
                    out.write(13);
                    continue block11;
                }
                case 34: {
                    out.write(34);
                    continue block11;
                }
                case 92: {
                    out.write(92);
                    continue block11;
                }
            }
            if (current == 120) {
                current = this.tokenizer.readByte();
                int first = this.decodeDigit(current);
                if (first > 15) {
                    this.tokenizer.unreadByte();
                    out.write(120);
                    continue;
                }
                current = this.tokenizer.readByte();
                int second = this.decodeDigit(current);
                if (second > 15) {
                    out.write((byte)first);
                    continue;
                }
                int value = first << 4 | second;
                out.write((byte)value);
                continue;
            }
            int firstOctal = this.decodeDigit(current);
            if (firstOctal >= 8) continue;
            current = this.tokenizer.readByte();
            int secondOctal = this.decodeDigit(current);
            if (secondOctal > 7) {
                out.write((byte)firstOctal);
                this.tokenizer.unreadByte();
                continue;
            }
            current = this.tokenizer.readByte();
            int thirdOctal = this.decodeDigit(current);
            int value = firstOctal << 3 | secondOctal;
            if (thirdOctal > 7) {
                out.write((byte)(firstOctal << 3 | secondOctal));
                this.tokenizer.unreadByte();
                continue;
            }
            if ((value = value << 3 | thirdOctal) > 255) {
                throw new YsonError(String.format("Invalid escape sequence: \\%d%d%d", firstOctal, secondOctal, thirdOctal));
            }
            out.write((byte)value);
        }
        return out.toByteArray();
    }

    private int decodeDigit(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        return Integer.MAX_VALUE;
    }

    private String debugByteString(byte b) {
        StringWriter writer = new StringWriter();
        writer.write(39);
        YsonTextUtils.writeQuotedByte(b, writer);
        writer.write(39);
        return writer.toString();
    }
}

